/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.controller {
	
	import jp.co.fujitsu.reffi.client.flex.model.DefaultModel;
	
	/**
	 * <p>[概 要]</p>
	 * フレームワーク挙動情報が格納されたクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * 以下のような基本情報が設定されます。
	 * <ol>
	 *   <li>エラー発生時にコントローラでダイアログ表示をするかどうか</li>
	 *   <li>アクション起動時に機能モデルが登録されていない場合、どのモデルをデフォルト実行するか</li>
	 * </ol>
	 * BaseControllerを継承した具象コントローラ#initializeメソッドで情報を変更することが出来ます。
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 * @see jp.co.fujitsu.reffi.client.flex.controller.BaseController#initialize()
	 */ 
	public class ClientConfig {
		
		// Actionで実行モデルがリザーブされたかった場合にデフォルトで実行されるモデルクラス
		private var _defaultModelClass:Class = Class(DefaultModel);

		// エラー時のアラートダイアログ表示フラグ
		private var _showAlertOnError:Boolean = true;
		
		// コンポーネント検索系処理で対象外にするコンポーネントクラス型が入った配列
		private var _excludeFromComponentSearch:Array = new Array();
		
		
		/**
		 * <p>[概 要]</p>
		 * Actionで実行モデルがリザーブされたかった場合にデフォルトで実行されるモデルクラスです.
		 *
		 * <p>[詳 細]</p>
		 * Action実行時にモデルが予約されていなかった場合に実行される
		 * デフォルトのモデルクラス情報を保持するプロパティです。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @default jp.co.fujitsu.reffi.client.flex.model.DefaultModel 
		 */		
		public function get defaultModelClass():Class {
			return this._defaultModelClass;
		}
		public function set defaultModelClass(clazz:Class):void {
			this._defaultModelClass = clazz;
		}
		
		/**
		 * <p>[概 要]</p>
		 * エラー発生時のダイアログ通知可否フラグです.
		 *
		 * <p>[詳 細]</p>
		 * エラー発生時、最終的にコントローラにキャッチされたエラーを、
		 * ダイアログ表示するかどうかの情報を保持するプロパティです。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @default true
		 */		
		public function get showAlertOnError():Boolean {
			return this._showAlertOnError;
		}
		public function set showAlertOnError(showAlertOnError:Boolean):void {
			this._showAlertOnError = showAlertOnError;
		}
		
		/**
		 * <p>[概 要]</p>
		 * コンポーネント検索時、検索対象外となるコンポーネント型が入った配列です.
		 *
		 * <p>[詳 細]</p>
		 * name属性値でコンポーネントを検出するgetComponentByName等は、
		 * 画面上のコンテナオブジェクトを再帰的に走査します。<br />
		 * この走査の対象外となるクラス型が入った配列プロパティです。<br />
		 * コンポーネントの中を走査することがセキュリティエラーに
		 * なってしまうようなコンポーネント型をアプリケーション初期化時に追加します。
		 *  
		 * <p>[備 考]</p>
		 * 
		 * @see jp.co.fujitsu.reffi.client.flex.util.CompositionSearchUtil
		 * @default 要素0の配列
		 */		
		public function get excludeFromComponentSearch():Array {
			return this._excludeFromComponentSearch;
		}
		public function set excludeFromComponentSearch(excludeFromComponentSearch:Array):void {
			this._excludeFromComponentSearch = excludeFromComponentSearch;
		}
	}
}
