/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.validator;

import java.util.List;

import com.nexaweb.xml.Element;

/**
 * <p>[概 要] </p>
 * １バリデーションエラーの情報を保持するクラスです。
 * 
 * <p>[詳 細] </p>
 * <ul>
 *     <li>バリデーションエラーを起こしたエレメントのインスタンス</li>
 *     <li>バリデーションエラーメッセージ</li>
 *     <li>エラー見出し文字（設定されない場合はエレメントのname属性値）</li>
 * </ul>
 * を保持します。<br>
 * 
 * <p>[備 考] </p>
 * このクラスインスタンスを生成する必要は有りません。<br>
 * {@link jp.co.fujitsu.reffi.client.nexaweb.action.BaseAction#validate(List)}
 * 内で生成され、ValidationErrosオブジェクトに集約されます。
 * 
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ValidateError {

	/** バリデーションエラーを起こしたエレメントです。 */
	private Element element;
	
	/** バリデータから譲渡されたエラーメッセージです。 */
	private String message;
	
	/** バリデータから譲渡されたエラー見出し文字です。（デフォルトはname属性値） */
	private String headWord;
	
	
	/**
	 * <p>[概 要] </p>
	 * バリデーションエラーを起こしたエレメントを返却します。
	 * 
	 * <p>[詳 細] </p>
	 * elementフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデーションエラーを起こしたエレメント
	 */
	public Element getElement() {
		return element;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデーションエラーを起こしたエレメントを設定します。
	 * 
	 * <p>[詳 細] </p>
	 * elementフィールドを引数elementで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param element バリデーションエラーを起こしたエレメント
	 */
	public void setElement(Element element) {
		this.element = element;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラーメッセージを返却します。
	 * 
	 * <p>[詳 細] </p>
	 * messageフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデータから譲渡されたエラーメッセージ
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラーメッセージを設定します。
	 * 
	 * <p>[詳 細] </p>
	 * messageフィールドを引数messageで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param message バリデータから譲渡されたエラーメッセージ
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラー見出し文字を返却します。
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデータから譲渡されたエラー見出し文字
	 */
	public String getHeadWord() {
		return headWord;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラー見出し文字を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param headWord バリデータから譲渡されたエラー見出し文字
	 */
	public void setHeadWord(String headWord) {
		this.headWord = headWord;
	}

	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * elementフィールドに引数elementを、messageフィールドに引数messageを設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param element バリデーションエラーを起こしたエレメント
	 * @param message バリデータから譲渡されたエラーメッセージ
	 */
	public ValidateError(Element element, String message){
		this.element = element;
		this.message = message;
	}
	
	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * {@link #ValidateError(Element, String)}オーバーロードコンストラクタをコール後、<br>
	 * headWordフィールドを引数headWordで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param element バリデーションエラーを起こしたエレメント
	 * @param message バリデータから譲渡されたエラーメッセージ
	 * @param headWord バリデータから譲渡されたエラー見出し文字
	 */
	public ValidateError(Element element, String message, String headWord){
		this(element, message);
		this.headWord = headWord;
	}
}
