/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.common.nexaweb.dialog;

import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialogIF;

public class CoreDialog
implements CoreDialogIF {
    private String id;
    private String name;
    private String title;
    private String message;
    private String dialogType;
    private String bgColor;
    private String bgImage;
    private Integer width;
    private Integer height;
    private Integer x;
    private Integer y;
    private Boolean centered;
    private Boolean resizable;
    private Boolean richText;
    private Boolean modal;
    private Boolean maximized;
    private Boolean showTitleBar;
    private Boolean messageDialogFlg;

    @Override
    public String getTagXml() {
        StringBuilder sb = new StringBuilder();
        if (this.messageDialogFlg != null && this.messageDialogFlg.booleanValue()) {
            sb.append("<messageDialog ");
        } else {
            sb.append("<dialog ");
        }
        sb.append("xmlns=\"http://openxal.org/ui/java\"");
        if (!this.isBlank(this.id)) {
            sb.append("id=\"" + this.id + "\" ");
        }
        if (!this.isBlank(this.name)) {
            sb.append("name=\"" + this.name + "\" ");
        }
        if (!this.isBlank(this.title) && this.showTitleBar != null && this.showTitleBar.booleanValue()) {
            sb.append("title=\"" + this.title + "\" ");
        }
        if (!this.isBlank(this.message)) {
            sb.append("message=\"" + this.message + "\" ");
        }
        if (!this.isBlank(this.dialogType)) {
            sb.append("type=\"" + this.dialogType + "\" ");
        }
        if (!this.isBlank(this.bgColor)) {
            sb.append("backgroundColor=\"" + this.bgColor + "\" ");
        }
        if (!this.isBlank(this.bgImage)) {
            sb.append("backgroundImage=\"" + this.bgImage + "\" ");
        }
        if (this.width != null) {
            sb.append("width=\"" + this.width + "\" ");
        }
        if (this.height != null) {
            sb.append("height=\"" + this.height + "\" ");
        }
        if (this.x != null) {
            sb.append("x=\"" + this.x + "\" ");
        }
        if (this.y != null) {
            sb.append("y=\"" + this.y + "\" ");
        }
        if (this.centered != null) {
            sb.append("centered=\"" + this.centered + "\" ");
        }
        if (this.resizable != null) {
            sb.append("resizable=\"" + this.resizable + "\" ");
        }
        if (this.richText != null) {
            sb.append("richText=\"" + this.richText + "\" ");
        }
        if (this.modal != null) {
            sb.append("modal=\"" + this.modal + "\" ");
        }
        if (this.maximized != null) {
            sb.append("maximized=\"" + this.maximized + "\" ");
        }
        if (this.showTitleBar != null) {
            sb.append("showTitleBar=\"" + this.showTitleBar + "\" ");
        }
        sb.append("/>");
        return sb.toString();
    }

    private boolean isBlank(String str) {
        boolean result = true;
        if (str != null && str.length() > 0) {
            result = false;
        }
        return result;
    }

    public CoreDialog(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.title = builder.title;
        this.message = builder.message;
        this.dialogType = builder.dialogType;
        this.bgColor = builder.bgColor;
        this.bgImage = builder.bgImage;
        this.width = builder.width;
        this.height = builder.height;
        this.x = builder.x;
        this.y = builder.y;
        this.centered = builder.centered;
        this.resizable = builder.resizable;
        this.richText = builder.richText;
        this.modal = builder.modal;
        this.maximized = builder.maximized;
        this.showTitleBar = builder.showTitleBar;
        this.messageDialogFlg = builder.messageDialogFlg;
    }

    public static class Builder {
        private String title;
        private String message;
        private String id = null;
        private String name = null;
        private String dialogType = MessageDialogType.PLAIN.getType();
        private String bgColor = null;
        private String bgImage = null;
        private Integer width = null;
        private Integer height = null;
        private Integer x = null;
        private Integer y = null;
        private Boolean centered = true;
        private Boolean resizable = null;
        private Boolean richText = null;
        private Boolean modal = true;
        private Boolean maximized = null;
        private Boolean showTitleBar = true;
        private Boolean messageDialogFlg = true;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dialogType(String dialogType) {
            this.dialogType = dialogType;
            return this;
        }

        public Builder bgColor(String bgColor) {
            this.bgColor = bgColor;
            return this;
        }

        public Builder bgImage(String bgImage) {
            this.bgImage = bgImage;
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public Builder x(Integer x) {
            this.x = x;
            return this;
        }

        public Builder y(Integer y) {
            this.y = y;
            return this;
        }

        public Builder centered(Boolean centered) {
            this.centered = centered;
            return this;
        }

        public Builder resizable(Boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public Builder richText(Boolean richText) {
            this.richText = richText;
            return this;
        }

        public Builder modal(Boolean modal) {
            this.modal = modal;
            return this;
        }

        public Builder maximized(Boolean maximized) {
            this.maximized = maximized;
            return this;
        }

        public Builder showTitleBar(Boolean showTitleBar) {
            this.showTitleBar = showTitleBar;
            return this;
        }

        public Builder messageDialogFlg(Boolean messageDialogFlg) {
            this.messageDialogFlg = messageDialogFlg;
            return this;
        }

        public Builder(String title, String message) {
            this.title = title;
            this.message = this.escape(message);
        }

        public CoreDialog build() {
            return new CoreDialog(this);
        }

        private String escape(String s) {
            s = s.replace("<", "&lt;");
            s = s.replace(">", "&gt;");
            s = s.replace("\"", "&quot;");
            return s;
        }
    }

    public static enum MessageDialogType {
        ERROR("error"),
        QUESTION("question"),
        INFO("info"),
        WARNING("warning"),
        PLAIN("plain");

        private String type;

        private MessageDialogType(String str) {
            this.type = str;
        }

        public String getType() {
            return this.type;
        }
    }
}

