/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.swing.event;

import java.util.EventObject;

import jp.co.fujitsu.reffi.client.swing.util.MessageDialog;

/**
 * <p>[概 要] </p>
 * モードレスメッセージダイアログのユーザインタラクション結果が格納されるイベントクラスです。
 * 
 * <p>[詳 細] </p>
 * MessageDialogUtilによるモードレスメッセージ表示後、メッセージダイアログが
 * 閉じる契機で発生するイベントです。<br>
 * どのボタンが押されたか、ユーザの選択がreturnValueフィールドに格納されます。
 * 
 * <p>[備 考] </p>
 * 
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @see jp.co.fujitsu.reffi.client.swing.listener.MessageDialogListener
 * @author Project Reffi 
 */
public class MessageDialogEvent extends EventObject {

	private static final long serialVersionUID = -4413338257819059035L;
	
	/** 押下ボタン識別値です。 */
	private int returnValue;

	/**
	 * <p>[概 要] </p>
	 * 押下ボタン識別値を返却します。
	 * 
	 * <p>[詳 細] </p>
	 * returnValueフィールド値を返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return 押下ボタン識別値
	 */
	public int getReturnValue() {
		return returnValue;
	}

	/**
	 * <p>[概 要] </p>
	 * 押下ボタン識別値を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * returnValueフィールド値を設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param returnValue 押下ボタン識別値
	 */
	public void setReturnValue(int returnValue) {
		this.returnValue = returnValue;
	}

	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * イベントソースとボタン押下値をフィールドに保存します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param source イベントを発生させたメッセージダイアログ
	 * @param returnValue 押下ボタン識別値
	 */
	public MessageDialogEvent(MessageDialog source, int returnValue) {
		super(source);
		
		setReturnValue(returnValue);
	}
}
