/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.controller;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jp.co.fujitsu.reffi.client.swing.action.AbstractAction;
import jp.co.fujitsu.reffi.client.swing.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.swing.controller.Controller;
import jp.co.fujitsu.reffi.client.swing.controller.EventBinder;
import jp.co.fujitsu.reffi.client.swing.controller.EventInvocationHandler;
import jp.co.fujitsu.reffi.client.swing.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.swing.listener.ContainerListenerImpl;
import jp.co.fujitsu.reffi.client.swing.listener.WindowOpenShutListener;
import jp.co.fujitsu.reffi.client.swing.manager.WindowManager;

public abstract class AbstractController
implements Controller,
WindowOpenShutListener {
    private EventBinder eventBinder;
    private Map<Object, Object> permanent;
    private ClientConfig clientConfig;
    private WindowManager windowManager;
    private Map<Integer, Map<Integer, Map<String, Object>>> errorComponentSnapshot;
    private volatile Vector<String> invokeThreadIds = new Vector();

    public EventBinder getEventBinder() {
        return this.eventBinder;
    }

    public void setEventBinder(EventBinder eventBinder) {
        this.eventBinder = eventBinder;
    }

    public Map<Object, Object> getPermanent() {
        return this.permanent;
    }

    public void setPermanent(Map<Object, Object> Permanent) {
        this.permanent = Permanent;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public Map<Integer, Map<Integer, Map<String, Object>>> getErrorComponentSnapshot() {
        return this.errorComponentSnapshot;
    }

    public void setErrorComponentSnapshot(Map<Integer, Map<Integer, Map<String, Object>>> errorComponentSnapshot) {
        this.errorComponentSnapshot = errorComponentSnapshot;
    }

    public AbstractController() {
        this.setEventBinder(new EventBinder(this));
        this.setClientConfig(new ClientConfig());
        this.setPermanent(new HashMap<Object, Object>());
        WindowManager.getInstance().addWindowOpenShutListener(this);
        this.setWindowManager(WindowManager.getInstance());
        this.setErrorComponentSnapshot(new HashMap<Integer, Map<Integer, Map<String, Object>>>());
        this.bind(this.getEventBinder());
        this.initialize(this.getClientConfig());
        this.postInitialize(this.getClientConfig());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractController.this.shutdown();
            }
        });
    }

    protected void initialize(ClientConfig config) {
    }

    protected void postInitialize(ClientConfig config) {
    }

    public void bindEvents(Component addedComponent) {
        String componentName = addedComponent.getName();
        if (componentName != null && !"".equals(componentName)) {
            List<Class<? extends EventListener>> listenerTypes = this.eventBinder.getListenerTypes(addedComponent.getName());
            for (Class<? extends EventListener> listenerType : listenerTypes) {
                List<String> eventTypes = this.eventBinder.getEventTypes(componentName, listenerType);
                this.addListener(addedComponent, listenerType, eventTypes);
            }
        }
    }

    public void addListener(Component component, Class<? extends EventListener> listenerType, List<String> eventTypes) {
        try {
            EventInvocationHandler handler = new EventInvocationHandler(this, listenerType, eventTypes);
            EventListener eventListener = (EventListener)Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
            String addMethodName = "add" + listenerType.getSimpleName();
            Method addMethod = component.getClass().getMethod(addMethodName, listenerType);
            addMethod.invoke((Object)component, eventListener);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerFacade(EventObject e, Class<? extends EventListener> listenerType, String eventType, EventListener eventListenerProxy) {
        final Class<? extends AbstractAction> actionClass = this.getEventBinder().getActionClass(((Component)e.getSource()).getName(), listenerType, eventType);
        final ParameterMapping parameterMapping = this.createParameterMapping(e, listenerType, eventType, eventListenerProxy);
        if (this.getClientConfig().isDuplicateActionInvoke()) {
            this.invoke(actionClass, parameterMapping);
        } else {
            final String eventSourceId = String.valueOf(e.getSource().hashCode());
            Vector<String> vector = this.invokeThreadIds;
            synchronized (vector) {
                if (!this.invokeThreadIds.contains(eventSourceId)) {
                    this.invokeThreadIds.add(eventSourceId);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                AbstractController.this.invoke(actionClass, parameterMapping);
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractController.this.invokeThreadIds.remove(eventSourceId);
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            }
        }
    }

    protected ParameterMapping createParameterMapping(EventObject e, Class<? extends EventListener> listenerType, String eventType, EventListener eventListenerProxy) {
        ParameterMapping ret = new ParameterMapping();
        ret.setEventObject(e);
        ret.setEventSource(e.getSource());
        if (e.getSource() instanceof Component) {
            ret.setEventSourceParent(((Component)e.getSource()).getParent());
        }
        ret.setEventListenerType(listenerType);
        ret.setEventListener(eventListenerProxy);
        ret.setEventType(eventType);
        return ret;
    }

    protected void bind(EventBinder eventBinder) {
    }

    @Override
    public void windowOpen(AWTEvent evt) {
        this.registWindow((Window)evt.getSource());
        this.getErrorComponentSnapshot().put(evt.getSource().hashCode(), new HashMap());
    }

    @Override
    public void windowShut(AWTEvent evt) {
        if (this.getClientConfig().isAutoWindowDispose()) {
            ((Window)evt.getSource()).dispose();
        }
        this.getErrorComponentSnapshot().remove(evt.getSource());
    }

    public void registWindow(Window window) {
        this.searchComponent(window);
    }

    private void searchComponent(Component addedComponent) {
        this.bindEvents(addedComponent);
        if (addedComponent instanceof Container) {
            Component[] cs;
            for (Component c : cs = ((Container)addedComponent).getComponents()) {
                this.searchComponent(c);
            }
            ((Container)addedComponent).addContainerListener(new ContainerListenerImpl(this));
        }
    }

    protected void shutdown() {
    }
}

