/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.fujitsu.reffi.client.swing.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.swing.db.Connector;
import jp.co.fujitsu.reffi.client.swing.db.ConnectorFactory;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public class DatabaseCore
extends BaseModel {
    public static final String DB_DATASOURCE = "db.datasource";
    public static final String DB_DRIVER_FQCN = "db.driver.fqcn";
    public static final String DB_URL = "db.url";
    public static final String DB_USER = "db.user";
    public static final String DB_PASSWORD = "db.password";
    public static final String DB_AUTO_COMMIT = "db.auto.commit";
    private String datasource;
    private String driverFqcn;
    private String url;
    private String user;
    private String password;
    private boolean autoCommit = true;
    private Connector connector;
    private String sql;
    private List<Object> sqlParameters = new ArrayList<Object>();
    private PreparedStatement statement;
    private boolean asList;

    public String getDatasource() {
        if (this.datasource == null) {
            ClientConfig config = this.getController().getClientConfig();
            return config.getDefaultDatabaseEnvironment().get(DB_DATASOURCE);
        }
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getDriverFqcn() {
        if (this.driverFqcn == null) {
            ClientConfig config = this.getController().getClientConfig();
            return config.getDefaultDatabaseEnvironment().get(DB_DRIVER_FQCN);
        }
        return this.driverFqcn;
    }

    public void setDriverFqcn(String driverFqcn) {
        this.driverFqcn = driverFqcn;
    }

    public String getUrl() {
        if (this.url == null) {
            ClientConfig config = this.getController().getClientConfig();
            return config.getDefaultDatabaseEnvironment().get(DB_URL);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        if (this.user == null) {
            ClientConfig config = this.getController().getClientConfig();
            return config.getDefaultDatabaseEnvironment().get(DB_USER);
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        if (this.password == null) {
            ClientConfig config = this.getController().getClientConfig();
            return config.getDefaultDatabaseEnvironment().get(DB_PASSWORD);
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public List<Object> getSqlParameters() {
        return this.sqlParameters;
    }

    public void setSqlParameters(List<Object> sqlParameters) {
        this.sqlParameters = sqlParameters;
    }

    public void addSqlParameter(Object parameter) {
        this.sqlParameters.add(parameter);
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public void setStatement(PreparedStatement statement) {
        this.statement = statement;
    }

    public boolean isAsList() {
        return this.asList;
    }

    public void setAsList(boolean asList) {
        this.asList = asList;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    protected boolean preproc() throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        Connector connector = ConnectorFactory.getConnector(this);
        this.setConnector(connector);
        String sql = null;
        sql = this.presql();
        if (sql != null) {
            this.setSql(sql);
        }
        this.getConnector().open();
        return true;
    }

    @Override
    protected void mainproc() throws SQLException, Exception {
        Connection con = this.getConnector().getConnection();
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        this.sqlparam(stmt);
        this.setStatement(stmt);
        boolean bResult = this.execsql();
        Object result = null;
        if (bResult) {
            List<Map<String, Object>> resultList;
            this.sqlresult();
            ResultSet resultSet = stmt.getResultSet();
            result = this.isAsList() ? (resultList = this.getRows(resultSet)) : resultSet;
        } else {
            this.sqlupdate();
            int updateCount = stmt.getUpdateCount();
            result = updateCount;
        }
        this.setResult(result);
    }

    @Override
    protected void postproc() throws Exception {
        this.getConnector().commit();
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(this.getResult());
        this.fireModelSuccess(successEvent);
        this.fireModelFinished(new ModelProcessEvent(this));
    }

    @Override
    protected void finalproc() {
        try {
            this.getConnector().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String presql() {
        return null;
    }

    protected void sqlparam(Statement stmt) throws SQLException {
        List<Object> sqlParameters = this.getSqlParameters();
        for (int i = 0; i < sqlParameters.size(); ++i) {
            Object parameter = sqlParameters.get(i);
            ((PreparedStatement)stmt).setObject(i + 1, parameter);
        }
    }

    protected boolean execsql() throws SQLException {
        return this.getStatement().execute();
    }

    protected void sqlresult() throws Exception {
    }

    protected void sqlupdate() {
    }

    protected List<Map<String, Object>> getRows(ResultSet rs) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            Map<String, Object> map = this.getRow(rs);
            list.add(map);
        }
        return list;
    }

    protected Map<String, Object> getRow(ResultSet rs) throws Exception {
        HashMap<String, Object> map = null;
        if (rs != null) {
            map = new HashMap<String, Object>();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int ii = 1; ii <= rsmd.getColumnCount(); ++ii) {
                String columnname = rsmd.getColumnName(ii);
                Object columnvalue = rs.getObject(ii);
                map.put(columnname, columnvalue);
            }
        }
        return map;
    }
}

