/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.common.exception;

/**
 * <p>[概 要]</p>
 * フレームワーク内共通例外クラスです。
 * <p>[詳 細]</p>
 * corelogicフレームワーク内で発生した、想定される例外は
 * 全てこのクラスにラッピングされてスローされます。
 * <p>[備 考]</p>
 * 
 * @author Project Reffi
 */
public class CoreLogicException extends AbstractCoreException {
	/** シリアルバージョンUID */ 
	private static final long serialVersionUID = 6285526206463903933L;

	/**
	 * エラーメッセージリソースファイルを返却します。
	 * 
	 * @return エラーメッセージリソースファイル名前空間
	 */
	protected String getMessageSource(){
		return "jp.co.fujitsu.reffi.common.exception.corelogic_message";
	}
	
	public CoreLogicException(){
		
	}
	
	/**
	 * メッセージIDを指定するコンストラクタです。
	 * 処理は基底クラスであるAbstractCoreExceptionに委譲します。
	 * 
	 * @param id メッセージID
	 */
	public CoreLogicException(String id) {
		super(id);
	}

	/**
	 * メッセージIDと原因例外を引数に取るコンストラクタです。
	 * 処理は基底クラスであるAbstractCoreExceptionに委譲します。
	 * 
	 * @param id メッセージID
	 * @param e cause
	 */
	public CoreLogicException(String id, Throwable e) {
		super(id, e);
	}
}
