/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.messaging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.fujitsu.reffi.server.messaging.AbstractMessageSender;

public enum SenderManager {
    instance;

    public static final int DELAY_START = 0;
    public static final int DEFAULT_TIME = 1000;
    private Map<String, Timer> _timerMap = new HashMap<String, Timer>();

    public synchronized void addMessageSender(String name, AbstractMessageSender messageSender) {
        this.addMessageSender(name, messageSender, 1000);
    }

    public synchronized void addMessageSender(String name, final AbstractMessageSender messageSender, int time) {
        if (this._timerMap.containsKey(name)) {
            return;
        }
        Timer _timer = new Timer(true);
        _timer.schedule(new TimerTask(){

            @Override
            public void run() {
                messageSender.runSender();
            }
        }, 0L, (long)time);
        this._timerMap.put(name, _timer);
    }

    public synchronized void cancelMessageSender(String name) {
        if (this._timerMap.containsKey(name)) {
            this._timerMap.get(name).cancel();
            this._timerMap.remove(name);
        }
    }

    public synchronized boolean hasMessageSender(String name) {
        return this._timerMap.containsKey(name);
    }

    public synchronized void cancelAllMessageSender() {
        Iterator<Timer> itr = this._timerMap.values().iterator();
        while (itr.hasNext()) {
            itr.next().cancel();
        }
        this._timerMap.clear();
    }
}

