/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.flex.web.controller;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.co.fujitsu.reffi.server.invoker.Invoker;
import jp.co.fujitsu.reffi.server.invoker.InvokerFactory;
import flex.messaging.FlexContext;

/**
 * <p>[概 要]</p>
 * Flex用サーバコントローラクラス。
 * 
 * <p>[詳 細]</p>
 * Flexにて利用するモデル実行コントローラクラスです。
 * <br />
 * 本クラスはFlexサーバプロダクト「LiveCycleDataServices(以下LCDS)」や「BlazeDS」にて利用できる
 * もので、Flexのサーバ側設定ファイルである、「remoting-config.xml」へ定義します。
 * <br />
 * 以下はその設定例です。
 * 
 * <pre class="samplecode">
 *&lt;destination id="remote-controller"&gt;
 *  &lt;properties&gt;
 *    &lt;source&gt;jp.co.fujitsu.reffi.server.flex.web.controller.RPCController&lt;/source&gt;
 *    &lt;scope&gt;application&lt;/scope&gt;
 *  &lt;/properties&gt;
 *&lt;/destination&gt;
 * </pre>
 * 
 * <p>
 * 本クラスでは、クライアントからActionScriptのObject型にて送信されたデータを受信し、
 * 受信データ内に設定されているモデルクラスを{@link jp.co.fujitsu.reffi.server.invoker.Invoker}経由にて実行します。
 * (モデルクラスの実装については{@link jp.co.fujitsu.reffi.server.model.AbstractModel})クラスを参照)
 * <br />
 * {@link jp.co.fujitsu.reffi.server.invoker.Invoker}では開発者が実装したモデルを実行し、実行した結果を本クラスでは
 * 直接クライアントへ送信します。
 * <br />
 * これはLCDSやBlazeDSにて実装されているAMF通信を利用し、サーバ側のオブジェクトを
 * クライアント側のActionScriptで認識できる機能を利用するためです。
 * <br />
 * オブジェクト変換の詳細については<a href="http://livedocs.adobe.com/flex/3_jp/html/data_access_4.html#475327">Flex3開発ガイド</a>を参照してください。
 * </p>
 * <p>
 * クライアントからのデータ送信についてはReffiが提供するクライアント側のモデル
 * クラス「RPCControllerClientCore」を利用する必要があります。
 * </p>
 * 
 * <p>[備 考]</p>
 *
 * @author Project Reffi
 */
public class RPCController {
	/**
	 * <p>[概 要]</p>
	 * コントローラ実行。
	 * <p>[詳 細]</p>
	 * 指定されたクラスのメソッドを実行します。
	 * <p>[備 考]</p>
	 * 
	 * @param parameters Flexクライアントで生成されたDictionary
	 * @return 実行メソッド返却値
	 * @throws Exception モデル実行エラーの場合
	 */
	public Object invoke(Map<Object, Object> parameters) throws Exception {
		try {
			setRequestParameters(parameters);
			Invoker invoker = InvokerFactory.getInvoker();
			return invoker.invoke(parameters);
		} catch (Exception e) {
			throw trap(e);
		}
	}
	
	protected Exception trap(Throwable t) {
		if (t instanceof Exception) {
			return (Exception)t;
		}
		return new Exception(t);
	}
	
	@SuppressWarnings("unchecked")
	private void setRequestParameters(Map<Object, Object> parameters) {
		HttpServletRequest request = FlexContext.getHttpRequest();
		Enumeration<String> names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			Object attr = request.getAttribute(name);
			parameters.put(name, attr);
		}
	}
}
