/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.web.filter;

import java.io.IOException;
import java.text.NumberFormat;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>[概 要]</p>
 * 実行時間計測フィルター
 * <p>[詳 細]</p>
 * リクエスト/レスポンスの処理時間計測をログ出力にて行います。
 * <p>[備 考]</p>
 * 本フィルター定義は他のフィルター定義より上位に記述してください。

 * @author Project Reff
 */
public class ExecutionTimeFilter implements Filter {
	/** ロガー */
	private static final Log LOG = LogFactory.getLog(ExecutionTimeFilter.class);

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		/** */
	}

	@Override
	public void destroy() {
		/** */
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
		StringBuilder clientInfo = getClientInfo(request);
		LOG.info("==== Start: " + clientInfo + " ====");
		long start = System.currentTimeMillis();
		filterChain.doFilter(request, response);
		long finish = System.currentTimeMillis();
		String executionTime = NumberFormat.getInstance().format((finish - start));
		clientInfo.append(",ExecutionTime=").append(executionTime).append("ミリ秒");
		LOG.info("---- ExecutionTime: " + executionTime);
		LOG.info("==== Finish: " + clientInfo + " ====");
	}

	private StringBuilder getClientInfo(ServletRequest request) {
		HttpServletRequest httpServletRequest = (HttpServletRequest)request;
		return new StringBuilder(64)
		.append("[")
		.append("URI=").append(httpServletRequest.getRequestURI())
		.append(",")
		.append("IP=").append(httpServletRequest.getRemoteAddr())
		.append("]");
	}
}
