/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.fichier;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.morilib.db.fichier.Fichier;

public class MemoryFichier
implements Fichier {
    private static final int BUFSIZE = 16384;
    private String name;
    private char[] buf;
    private int length = -1;

    public MemoryFichier(String n) {
        this.name = n;
        this.buf = new char[16384];
    }

    @Override
    public boolean isFile() {
        return this.length >= 0;
    }

    @Override
    public boolean createNewFile() throws IOException {
        this.length = 0;
        return true;
    }

    @Override
    public Reader openReader() throws IOException {
        final int[] c = new int[1];
        if (this.length < 0) {
            throw new IOException();
        }
        c[0] = 0;
        return new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                if (c[0] < 0) {
                    throw new IOException();
                }
                if (c[0] >= MemoryFichier.this.length) {
                    return -1;
                }
                int l = c[0] + len >= MemoryFichier.this.length ? MemoryFichier.this.length - c[0] : len;
                System.arraycopy(MemoryFichier.this.buf, c[0], cbuf, off, l);
                c[0] = c[0] + l;
                return l;
            }

            @Override
            public void close() throws IOException {
                if (c[0] < 0) {
                    throw new IOException();
                }
                c[0] = -2;
            }
        };
    }

    @Override
    public Writer openWriter() throws IOException {
        final boolean[] c = new boolean[1];
        this.length = 0;
        c[0] = false;
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                if (c[0]) {
                    throw new IOException();
                }
                if (MemoryFichier.this.length + len >= 16384) {
                    throw new IOException();
                }
                System.arraycopy(cbuf, off, MemoryFichier.this.buf, MemoryFichier.this.length, len);
                MemoryFichier memoryFichier = MemoryFichier.this;
                memoryFichier.length = memoryFichier.length + len;
            }

            @Override
            public void close() throws IOException {
                if (c[0]) {
                    throw new IOException();
                }
                c[0] = true;
            }

            @Override
            public void flush() throws IOException {
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean delete() throws IOException {
        this.length = -1;
        return true;
    }

    @Override
    public Fichier[] listFichiers() {
        return null;
    }

    @Override
    public boolean renameTo(Fichier f) throws IOException {
        return false;
    }
}

