/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.jdbc.RelationsDatabaseMetadata;
import net.morilib.db.jdbc.RelationsPreparedStatement;
import net.morilib.db.jdbc.RelationsStatement;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlParser;

public class RelationsConnection
implements Connection {
    SqlEngine engine;
    SqlSchema schema;

    RelationsConnection(SqlEngine e, SqlSchema s) {
        this.engine = e;
        this.schema = s;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void abort(Executor e) throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    private void checkclose() throws SQLException {
        if (this.schema == null) {
            throw ErrorBundle.getDefault(20002, new Object[0]);
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkclose();
        this.schema = null;
        this.engine = null;
    }

    @Override
    public void commit() throws SQLException {
        this.checkclose();
    }

    @Override
    public Array createArrayOf(String s, Object[] a) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new RelationsStatement(this);
    }

    @Override
    public Statement createStatement(int s, int resultSetType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int s, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new RelationsDatabaseMetadata(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.schema == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkclose();
        return this.schema.isReadonly().isTrue();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String s) throws SQLException {
        throw new SQLException("prepared statement is not supported");
    }

    @Override
    public CallableStatement prepareCall(String s, int a, int v) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String s, int a, int b, int v) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String s) throws SQLException {
        try {
            return new RelationsPreparedStatement(this, DbSqlParser.parse(s));
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int resultSetType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
    }

    @Override
    public void setCatalog(String c) throws SQLException {
    }

    @Override
    public void setClientInfo(Properties p) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String k, String v) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int h) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor e, int a) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

