/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.morilib.db.jdbc.RelationsConnection;
import net.morilib.db.jdbc.RelationsParameterMetaData;
import net.morilib.db.jdbc.RelationsResultSet;
import net.morilib.db.jdbc.RelationsStatement;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.sqlcs.dml.SqlDml;
import net.morilib.db.sqlcs.dml.SqlSetExpression;

public class RelationsPreparedStatement
extends RelationsStatement
implements PreparedStatement {
    private Object stmt;
    private SortedMap<Integer, Object> param;

    RelationsPreparedStatement(RelationsConnection c, Object s) {
        super(c);
        this.stmt = s;
        this.param = new TreeMap<Integer, Object>();
    }

    private List<Object> paramToList() throws SQLException {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.param.size() > 0) {
            int j = this.param.lastKey();
            int i = 0;
            while (i <= j) {
                if (!this.param.containsKey(i)) {
                    throw ErrorBundle.getDefault(20006, new Object[0]);
                }
                l.add(this.param.get(i));
                ++i;
            }
        }
        return l;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.stmt instanceof SqlSetExpression) {
            try {
                Relation r = this.conn.engine.visit(this.conn.schema, (SqlSetExpression)this.stmt, this.paramToList());
                return new RelationsResultSet(this, r);
            }
            catch (IOException e) {
                throw ErrorBundle.getDefault(10037, new Object[0]);
            }
        }
        throw ErrorBundle.getDefault(10038, new Object[0]);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.stmt instanceof SqlSetExpression) {
            throw ErrorBundle.getDefault(20005, new Object[0]);
        }
        try {
            Object r = this.conn.engine.visit(this.conn.schema, this.stmt, this.paramToList());
            return r instanceof Number ? ((Number)r).intValue() : 0;
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    private void checkparam(int p) throws SQLException {
        this.checkclose();
        if (!(this.stmt instanceof SqlDml)) {
            throw ErrorBundle.getDefault(20007, new Object[0]);
        }
        if (p < 1 || p > ((SqlDml)this.stmt).getMaxParameter()) {
            throw ErrorBundle.getDefault(20007, new Object[0]);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, "");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, x ? Rational.ONE : Rational.ZERO);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, Rational.valueOf(x));
    }

    private String _esc(String s) {
        return s;
    }

    private void setstr(int p, String s) {
        this.param.put(p, this._esc(s));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, new String(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, new java.util.Date(x.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, new java.util.Date(x.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, new java.util.Date(x.getTime()));
    }

    private String tostr(Reader x) throws SQLException {
        StringBuffer b = new StringBuffer();
        char[] a = new char[1024];
        try {
            int l;
            while ((l = x.read(a)) >= 0) {
                b.append(new String(a, 0, l));
            }
            return b.toString();
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    private String tostr(InputStream x) throws SQLException {
        return this.tostr(new InputStreamReader(x));
    }

    private String tostr(Reader x, int len) throws SQLException {
        StringBuffer b = new StringBuffer();
        char[] a = new char[len];
        try {
            int l = x.read(a);
            if (l >= 0) {
                b.append(new String(a, 0, l));
            }
            return b.toString();
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    private String tostr(InputStream x, int len) throws SQLException {
        StringBuffer b = new StringBuffer();
        byte[] a = new byte[len];
        try {
            int l = x.read(a);
            if (l >= 0) {
                b.append(new String(a, 0, l));
            }
            return b.toString();
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.param.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        Object o = x == null ? RelationExpression.NULL : (x instanceof BigDecimal ? Rational.valueOf((BigDecimal)x) : (x instanceof BigInteger ? Rational.valueOf((BigInteger)x) : (x instanceof Double ? Rational.valueOf((Double)x) : (x instanceof Float ? Rational.valueOf(((Float)x).doubleValue()) : (x instanceof Number ? Rational.valueOf(((Number)x).longValue()) : (x instanceof java.util.Date ? new java.util.Date(((java.util.Date)x).getTime()) : this._esc(x.toString())))))));
        this.param.put(parameterIndex - 1, o);
    }

    @Override
    public boolean execute() throws SQLException {
        block5: {
            Object o;
            block4: {
                this.checkclose();
                try {
                    o = this.conn.engine.visit(this.conn.schema, this.stmt, this.paramToList());
                    if (!(o instanceof Relation)) break block4;
                    this.select0 = (Relation)o;
                    return true;
                }
                catch (IOException e) {
                    throw ErrorBundle.getDefault(10037, new Object[0]);
                }
            }
            if (!(o instanceof Number)) break block5;
            this.count0 = ((Number)o).intValue();
            return false;
        }
        this.count0 = 0;
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Calendar c = (Calendar)cal.clone();
        c.setTime(x);
        this.setDate(parameterIndex, new Date(c.getTimeInMillis()));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Calendar c = (Calendar)cal.clone();
        c.setTime(x);
        this.setDate(parameterIndex, new Date(c.getTimeInMillis()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Calendar c = (Calendar)cal.clone();
        c.setTime(x);
        this.setDate(parameterIndex, new Date(c.getTimeInMillis()));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkparam(parameterIndex);
        this.param.put(parameterIndex - 1, "");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.stmt instanceof SqlDml) {
            return new RelationsParameterMetaData(((SqlDml)this.stmt).getMaxParameter());
        }
        return new RelationsParameterMetaData(0);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x, (int)length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x, (int)length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x, (int)length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkparam(parameterIndex);
        this.setstr(parameterIndex - 1, this.tostr(x));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

