/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashSet;
import net.morilib.db.misc.BitUtils;
import net.morilib.db.misc.DoubleUtils;

public final class Rational {
    private BigInteger numer;
    private BigInteger denom;
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE);

    private Rational(BigInteger num, BigInteger den) {
        this.numer = num;
        this.denom = den;
    }

    public static final Rational valueOf(BigInteger num, BigInteger den) {
        BigInteger n = num;
        BigInteger d = den;
        int nsig = num.signum();
        int dsig = den.signum();
        if (dsig == 0) {
            throw new ArithmeticException("denominator is zero");
        }
        if (nsig == 0) {
            return ZERO;
        }
        if (dsig < 0) {
            n = n.negate();
            d = d.negate();
        }
        BigInteger gcd = n.gcd(d);
        n = n.divide(gcd);
        d = d.divide(gcd);
        return new Rational(n, d);
    }

    public static final Rational valueOf(long num, long den) {
        return Rational.valueOf(BigInteger.valueOf(num), BigInteger.valueOf(den));
    }

    public static final Rational valueOf(long num) {
        return Rational.valueOf(num, 1L);
    }

    public static Rational valueOf(BigDecimal v) {
        BigInteger n = v.unscaledValue();
        if (v.scale() > 0) {
            BigInteger d = BigInteger.TEN.pow(v.scale());
            return Rational.valueOf(n, d);
        }
        if (v.scale() < 0) {
            BigInteger d = BigInteger.TEN.pow(-v.scale());
            return Rational.valueOf(n.multiply(d), BigInteger.ONE);
        }
        return Rational.valueOf(n, BigInteger.ONE);
    }

    public static Rational valueOf(double val) {
        BigInteger n;
        BigInteger d;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new ArithmeticException("Infinity and NaN is not supported");
        }
        int e = DoubleUtils.getExponent(val);
        long f = DoubleUtils.getExponent(val);
        if (val == 0.0) {
            return ZERO;
        }
        if (f == 0L) {
            if (e >= 0) {
                d = BigInteger.ONE;
                n = BigInteger.valueOf(2L).pow(e);
            } else {
                d = BigInteger.valueOf(2L).pow(-e);
                n = BigInteger.ONE;
            }
        } else if (e >= -1022) {
            int m = BitUtils.getLsb(f) - 1;
            int t = 52 - m;
            f |= 0x100000L;
            if (e - t >= 0) {
                d = BigInteger.ONE;
                n = BigInteger.valueOf(2L).pow(e - t);
                n = n.multiply(BigInteger.valueOf(f >> m));
            } else {
                d = BigInteger.valueOf(2L).pow(t - e);
                n = BigInteger.valueOf(f >> m);
            }
        } else {
            d = BigInteger.valueOf(2L).pow(-1074);
            n = BigInteger.valueOf(f);
        }
        return Rational.valueOf(n, d);
    }

    public static Rational valueOf(BigInteger b) {
        return new Rational(b, BigInteger.ONE);
    }

    public BigDecimal toBigDecimal() {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        return n.divide(d);
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        return n.divide(d, mc);
    }

    public BigDecimal toBigDecimal(int scale) {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        return n.divide(d, scale, RoundingMode.HALF_UP);
    }

    public static Rational rationalize(Rational r1, Rational r2) {
        BigInteger c;
        BigInteger d;
        Rational y;
        Rational e = r2.compareTo(ZERO) < 0 ? r2.negate() : r2;
        Rational x = r1.add(e);
        if (x.equals(y = r1.subtract(e))) {
            return x;
        }
        BigInteger xn = x.numer;
        BigInteger xd = x.denom;
        BigInteger yn = y.numer;
        BigInteger yd = y.denom;
        BigInteger a = d = BigInteger.ONE;
        BigInteger b = c = BigInteger.ZERO;
        while (true) {
            BigInteger[] qx = xn.divideAndRemainder(xd);
            BigInteger[] qy = yn.divideAndRemainder(yd);
            BigInteger xq = qx[0];
            if (qx[1].signum() == 0) {
                return Rational.valueOf(a.multiply(xq).add(b), c.multiply(xq).add(d));
            }
            if (xq.compareTo(qy[0]) < 0) {
                return Rational.valueOf(a.multiply(xq.add(BigInteger.ONE)).add(b), c.multiply(xq.add(BigInteger.ONE)).add(d));
            }
            if (xq.compareTo(qy[0]) > 0) {
                throw new RuntimeException("implementation error");
            }
            BigInteger aa = a;
            BigInteger cc = c;
            a = a.multiply(xq).add(b);
            b = aa;
            c = c.multiply(xq).add(d);
            d = cc;
            xn = yd;
            yn = xd;
            xd = qy[1];
            yd = qx[1];
        }
    }

    public BigInteger getNumerator() {
        return this.numer;
    }

    public BigInteger getDenominator() {
        return this.denom;
    }

    public BigInteger getIntegerPart() {
        return this.numer.divide(this.denom);
    }

    public Rational add(Rational n) {
        BigInteger nd = this.denom.multiply(n.denom);
        BigInteger nn = this.numer.multiply(n.denom).add(n.numer.multiply(this.denom));
        return Rational.valueOf(nn, nd);
    }

    public Rational divide(Rational n) {
        BigInteger nd = this.denom.multiply(n.numer);
        BigInteger nn = this.numer.multiply(n.denom);
        return Rational.valueOf(nn, nd);
    }

    public boolean isEqualTo(Rational n) {
        return this.numer.equals(n.numer) && this.denom.equals(n.denom);
    }

    public Rational multiply(Rational n) {
        BigInteger nd = this.denom.multiply(n.denom);
        BigInteger nn = this.numer.multiply(n.numer);
        return Rational.valueOf(nn, nd);
    }

    public Rational subtract(Rational n) {
        BigInteger nd = this.denom.multiply(n.denom);
        BigInteger nn = this.numer.multiply(n.denom).subtract(n.numer.multiply(this.denom));
        return Rational.valueOf(nn, nd);
    }

    public Rational negate() {
        return new Rational(this.numer.negate(), this.denom);
    }

    public int signum() {
        return this.numer.signum();
    }

    public boolean isUnit() {
        return this.numer.equals(BigInteger.ONE) && this.denom.equals(BigInteger.ONE);
    }

    public boolean isZero() {
        return this.isEqualTo(ZERO);
    }

    public Rational multiply(int n) {
        BigInteger nn = this.numer.multiply(BigInteger.valueOf(n));
        return Rational.valueOf(nn, this.denom);
    }

    public Rational power(int n) {
        BigInteger nd = this.denom.pow(n);
        BigInteger nn = this.numer.pow(n);
        return Rational.valueOf(nn, nd);
    }

    public Rational invert() {
        return Rational.valueOf(this.denom, this.numer);
    }

    public double doubleValue() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }

    public float floatValue() {
        return this.numer.floatValue() / this.denom.floatValue();
    }

    public int castInt() {
        return this.castBigInteger().intValue();
    }

    public long castLong() {
        return this.castBigInteger().longValue();
    }

    public BigInteger castBigInteger() {
        return this.numer.divide(this.denom);
    }

    public BigInteger getBigIntegerFloor() {
        BigInteger[] r0 = this.numer.divideAndRemainder(this.denom);
        if (r0[1].equals(BigInteger.ZERO)) {
            return r0[0];
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return r0[0];
        }
        return r0[0].subtract(BigInteger.ONE);
    }

    public int intFloor() {
        return this.getBigIntegerFloor().intValue();
    }

    public long longFloor() {
        return this.getBigIntegerFloor().longValue();
    }

    public BigInteger getBigIntegerCeil() {
        BigInteger[] r0 = this.numer.divideAndRemainder(this.denom);
        if (r0[1].equals(BigInteger.ZERO)) {
            return r0[0];
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return r0[0].add(BigInteger.ONE);
        }
        return r0[0];
    }

    public int intCeil() {
        return this.getBigIntegerCeil().intValue();
    }

    public long longCeil() {
        return this.getBigIntegerCeil().longValue();
    }

    public boolean isInteger() {
        return this.denom.equals(BigInteger.ONE);
    }

    public int compareTo(Rational o) {
        BigInteger c = this.numer.multiply(o.denom);
        BigInteger d = o.numer.multiply(this.denom);
        return c.compareTo(d);
    }

    public Rational getRational() {
        return this;
    }

    public int getScale(int digit) {
        HashSet<BigInteger> c = new HashSet<BigInteger>();
        BigInteger d = this.numer.remainder(this.denom);
        c.add(d);
        BigInteger x = BigInteger.valueOf(digit);
        int r = 0;
        while ((d = d.multiply(x).remainder(this.denom)).signum() != 0) {
            if (c.contains(d)) {
                return Integer.MAX_VALUE;
            }
            c.add(d);
            ++r;
        }
        return r;
    }

    public int getScale() {
        return this.getScale(10);
    }

    public boolean equals(Object x) {
        if (x instanceof Rational) {
            Rational n = (Rational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.numer.hashCode();
        l = 37 * l + this.denom.hashCode();
        return l;
    }

    public String toString() {
        if (this.numer.signum() == 0) {
            return "0";
        }
        if (this.denom.equals(BigInteger.ONE)) {
            return this.numer.toString();
        }
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }
}

