/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class TableRenameRelation
extends AbstractRelation
implements NamedRelation {
    private Relation rel;
    private String as;

    public TableRenameRelation(Relation r, String a) {
        this.rel = r;
        this.as = a;
    }

    public Relation getRelation() {
        return this.rel;
    }

    @Override
    public String getName() {
        return this.as;
    }

    @Override
    public RelationCursor iterator() {
        final RelationCursor i = this.rel.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public RelationTuple next() throws IOException, SQLException {
                final RelationTuple r = i.next();
                return new RelationTuple(){

                    @Override
                    public Object get(String n) throws SQLException {
                        int c = n.indexOf(46);
                        if (c < 0) {
                            return r.get(n);
                        }
                        return r.get(n.substring(c + 1));
                    }

                    @Override
                    public RelationTuple copy() throws SQLException {
                        return new DefaultRelationTuple(this.toMap());
                    }

                    @Override
                    public Map<String, Object> toMap() throws SQLException {
                        List<SqlColumnDefinition> ases = TableRenameRelation.this.getColumnNames();
                        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                        int i = 0;
                        while (i < ases.size()) {
                            m.put(ases.get(i).getName(), this.get(ases.get(i).getName()));
                            ++i;
                        }
                        return m;
                    }
                };
            }
        };
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        List<SqlColumnDefinition> l = this.rel.getColumnNames();
        SqlColumnDefinition[] a = new SqlColumnDefinition[l.size()];
        int i = 0;
        while (i < l.size()) {
            String s = l.get(i).getName();
            s = s != null ? s : String.valueOf(i);
            a[i] = new SqlColumnDefinition(String.valueOf(this.as) + "." + s, l.get(i).getType(), l.get(i).getAttributes());
            ++i;
        }
        return Arrays.asList(a);
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        return this.rel.getDefinition(name);
    }
}

