/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.SandboxBaseFichier;
import net.morilib.db.schema.FileSqlSchema;
import net.morilib.db.schema.MemorySqlSchema;
import net.morilib.db.schema.SqlSchema;

public abstract class SqlSchemaFactory {
    private static final String URI_T = "jdbc:relations:error";
    private static final String URI_S = "jdbc:relations:sandbox";
    private static final Pattern URI_LOCAL = Pattern.compile("jdbc:relations://(/([^:/,]+/)+)");
    private static final SqlSchemaFactory _FAC = new SqlSchemaFactory(){

        @Override
        public SqlSchema getByURL(String url) throws IOException, SQLException {
            if (url.equals(SqlSchemaFactory.URI_T)) {
                return MemorySqlSchema.readProperties("ERROR_MSG", "CODE", "MESSAGE", SqlSchemaFactory.class.getResourceAsStream("/net/morilib/db/misc/relations_errors.properties"));
            }
            if (url.equals(SqlSchemaFactory.URI_S)) {
                SandboxBaseFichier f = new SandboxBaseFichier();
                return new FileSqlSchema(f, f);
            }
            Matcher m = URI_LOCAL.matcher(url);
            if (m.matches()) {
                FabriqueDeFichier f = FabriqueDeFichier.getDefault();
                return new FileSqlSchema(f, f.newInstance(m.group(1)));
            }
            return null;
        }
    };

    SqlSchemaFactory() {
    }

    public static SqlSchemaFactory getInstance() {
        return _FAC;
    }

    public abstract SqlSchema getByURL(String var1) throws IOException, SQLException;
}

