/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.ddl;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.ParseDate;
import net.morilib.db.sqlcs.ddl.SqlColumnType;

public class SqlTypeDate
extends SqlColumnType {
    private static final SimpleDateFormat F1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public Object cast(String s) throws SQLException {
        try {
            return s.equals("") ? "" : ParseDate.toDate(s);
        }
        catch (IllegalArgumentException e) {
            throw ErrorBundle.getDefault(10034, s);
        }
    }

    @Override
    public String string(Object o) throws SQLException {
        if (o instanceof Date) {
            return o.equals("") ? "" : F1.format((Date)o);
        }
        throw ErrorBundle.getDefault(10043, new Object[0]);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getSqlType() {
        return 93;
    }

    @Override
    public Class<?> getTypeClass() {
        return Date.class;
    }

    public int hashCode() {
        return 72;
    }

    public boolean equals(Object o) {
        return o instanceof SqlTypeDate;
    }

    public String toString() {
        return "DATE";
    }
}

