package net.morilib.db.fichier;

import java.io.File;
import java.io.IOException;

public abstract class FabriqueDeFichier {

	private static final FabriqueDeFichier
	_DF = new FabriqueDeFichier() {

		public Fichier newInstance(Fichier dir, String name) {
			return new FileFichier(new File(
					((FileFichier)dir).file, name));
		}

		public Fichier newInstance(String name) {
			return new FileFichier(new File(name));
		}

		public Fichier newInstance(File name) {
			return new FileFichier(name);
		}

		public Fichier createTempFile(String prefix,
				String suffix) throws IOException {
			return new FileFichier(File.createTempFile(prefix,
					suffix));
		}

	};

	public static FabriqueDeFichier getDefault() {
		return _DF;
	}

	/**
	 * 
	 * @param dir
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(Fichier dir, String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(java.io.File name);

	/**
	 * 
	 * @param prefix
	 * @param suffix
	 * @return
	 * @throws IOException
	 */
	public abstract Fichier createTempFile(String prefix,
			String suffix) throws IOException;

}
