package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlParser;

public class RelationsConnection implements Connection {

	SqlEngine engine;
	SqlSchema schema;

	RelationsConnection(SqlEngine e, SqlSchema s) {
		engine = e;
		schema = s;
	}

	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		return false;
	}

	public <T> T unwrap(Class<T> arg0) throws SQLException {
		throw new SQLException("not supported");
	}

	public void abort(Executor e) throws SQLException {
	}

	public void clearWarnings() throws SQLException {
		// ignore it
	}

	private void checkclose() throws SQLException {
		if(schema == null) {
			throw ErrorBundle.getDefault(20002);
		}
	}

	public void close() throws SQLException {
		checkclose();
		schema = null;
		engine = null;
	}

	public void commit() throws SQLException {
		checkclose();
		// ignore it
	}

	public Array createArrayOf(String s,
			Object[] a) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Blob createBlob() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Clob createClob() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public NClob createNClob() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public SQLXML createSQLXML() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Statement createStatement() throws SQLException {
		return new RelationsStatement(this);
	}

	public Statement createStatement(int s,
			int resultSetType) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Statement createStatement(int s,
			int resultSetType,
			int resultSetConcurrency) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public boolean getAutoCommit() throws SQLException {
		return true;
	}

	public String getCatalog() throws SQLException {
		return null;
	}

	public Properties getClientInfo() throws SQLException {
		return null;
	}

	public String getClientInfo(String arg0) throws SQLException {
		return null;
	}

	public int getHoldability() throws SQLException {
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	public DatabaseMetaData getMetaData() throws SQLException {
		return new RelationsDatabaseMetadata(this);
	}

	public int getTransactionIsolation() throws SQLException {
		return Connection.TRANSACTION_NONE;
	}

	public Map<String, Class<?>> getTypeMap() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public SQLWarning getWarnings() throws SQLException {
		return null;
	}

	public boolean isClosed() throws SQLException {
		return schema == null;
	}

	public boolean isReadOnly() throws SQLException {
		checkclose();
		return schema.isReadonly().isTrue();
	}

	public boolean isValid(int timeout) throws SQLException {
		return false;
	}

	public String nativeSQL(String sql) throws SQLException {
		return sql;
	}

	public CallableStatement prepareCall(String s) throws SQLException {
		throw new SQLException("prepared statement is not supported");
	}

	public CallableStatement prepareCall(String s, int a,
			int v) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public CallableStatement prepareCall(String s, int a, int b,
			int v) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(
			String s) throws SQLException {
		try {
			return new RelationsPreparedStatement(this,
					DbSqlParser.parse(s));
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	public PreparedStatement prepareStatement(String s,
			int resultSetType) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(String s,
			int[] columnIndexes) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(String s,
			String[] columnNames) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(String arg0,
			int resultSetType,
			int resultSetConcurrency) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public PreparedStatement prepareStatement(String arg0,
			int resultSetType, int resultSetConcurrency,
			int resultSetHoldability) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void releaseSavepoint(Savepoint s) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void rollback() throws SQLException {
		// TODO
		// ignore it
	}

	public void rollback(Savepoint s) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void setAutoCommit(boolean b) throws SQLException {
		// TODO
		// ignore it
	}

	public void setCatalog(String c) throws SQLException {
	}

	public void setClientInfo(
			Properties p) throws SQLClientInfoException {
		// ignore it
	}

	public void setClientInfo(String k,
			String v) throws SQLClientInfoException {
		// ignore it
	}

	public void setHoldability(int h) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void setNetworkTimeout(Executor e,
			int a) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void setReadOnly(boolean arg0) throws SQLException {
	}

	public Savepoint setSavepoint() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public Savepoint setSavepoint(String s) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	public void setTransactionIsolation(
			int level) throws SQLException {
		// ignore it
	}

	public void setTypeMap(
			Map<String, Class<?>> map) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

}
