/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.dml.SqlSelect;

public class RelationInSubquery
extends RelationExpression {
    private RelationExpression exp;
    private SqlSelect select;
    private String name;

    public RelationInSubquery(RelationExpression e, SqlSelect s) throws SQLException {
        if (s.getData().size() != 1) {
            throw ErrorBundle.getDefault(10012, new Object[0]);
        }
        this.select = s;
        this.name = s.getData().get(0).getAs();
        this.exp = e;
    }

    Object execsub(SqlEngine v, SqlSchema f, Object o) throws IOException, SQLException {
        Relation r = v.visit(this.select, Relations.NULLTUPLE, Collections.<Object>emptyList());
        RelationCursor i = r.iterator();
        while (i.hasNext()) {
            RelationTuple t = i.next();
            if (!o.equals(t.get(this.name))) continue;
            return RelationExpression.TRUE;
        }
        return RelationExpression.FALSE;
    }

    @Override
    public Object eval(final SqlEngine v, final SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        final Object o = this.exp.eval(v, f, tuple, m, group, h);
        if (o instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    try {
                        return RelationInSubquery.this.execsub(v, f, ((Delay)o).force());
                    }
                    catch (IOException e) {
                        throw ErrorBundle.getIODefault(e, new Object[0]);
                    }
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                }
            };
        }
        return this.execsub(v, f, o);
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public Object init(final SqlEngine v, final SqlSchema f) throws SQLException {
        final Object o = this.exp.init(v, f);
        if (o instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    try {
                        return RelationInSubquery.this.execsub(v, f, ((Delay)o).force());
                    }
                    catch (IOException e) {
                        throw ErrorBundle.getIODefault(e, new Object[0]);
                    }
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                }
            };
        }
        return "";
    }
}

