/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class RelationEditorTableModel
extends AbstractTableModel {
    private List<SqlColumnDefinition> head;
    private List<RelationTuple> list;
    private boolean dirty = false;
    private RelationTuple undo;
    private Object[] inst;
    private String name;
    private int urow;

    public RelationEditorTableModel(String n, Relation r) throws IOException, SQLException {
        this.name = n;
        this.head = r.getColumnNames();
        this.list = new ArrayList<RelationTuple>();
        RelationCursor c = r.iterator();
        while (c.hasNext()) {
            this.list.add(c.next());
        }
        this.inst = null;
    }

    @Override
    public int getRowCount() {
        return this.list.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.head.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.head.get(columnIndex).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.head.get(columnIndex).getName().getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == this.list.size()) {
            return this.inst != null ? this.inst[columnIndex] : "";
        }
        try {
            Map<String, Object> m = this.list.get(rowIndex).toMap();
            Iterator<Map.Entry<String, Object>> itr = m.entrySet().iterator();
            int i = 0;
            while (i < columnIndex) {
                ++i;
                itr.next();
            }
            Object o = itr.next().getValue();
            if (o instanceof Rational) {
                return ((Rational)o).toBigDecimal(4).stripTrailingZeros();
            }
            return o;
        }
        catch (SQLException e) {
            return "(fail to get)";
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.list.size()) {
            try {
                this.urow = rowIndex;
                RelationTuple v = this.list.get(this.urow);
                this.undo = this.undo == null ? v : this.undo;
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(v.toMap());
                Iterator itr = m.entrySet().iterator();
                int i = 0;
                while (i < columnIndex) {
                    ++i;
                    itr.next();
                }
                itr.next().setValue(aValue);
                this.list.set(rowIndex, new DefaultRelationTuple(m));
            }
            catch (SQLException sQLException) {}
        } else {
            if (this.inst == null) {
                this.inst = new Object[this.head.size()];
            }
            this.inst[columnIndex] = aValue;
        }
        this.dirty = true;
    }

    public void write(SqlSchema f) throws IOException, SQLException {
        if (this.inst != null) {
            this.insertTuple(f);
        } else if (this.dirty) {
            if (Relations.isUnique(f.getCreateTable(this.name), this.list)) {
                f.writeRelation(this.name, this.list);
                this.undo = null;
                this.dirty = false;
            } else {
                this.list.set(this.urow, this.undo);
                this.undo = null;
                this.dirty = false;
                throw ErrorBundle.getDefault(10001, new Object[0]);
            }
        }
    }

    public void insertTuple(SqlSchema f) throws IOException, SQLException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < this.inst.length) {
            m.put(this.head.get(i).getName(), this.inst[i] != null ? this.inst[i] : "");
            ++i;
        }
        if (!Relations.isUnique(f.getCreateTable(this.name), m, this.list)) {
            this.inst = null;
            throw ErrorBundle.getDefault(10001, new Object[0]);
        }
        this.list.add(new DefaultRelationTuple(m));
        this.inst = null;
        this.fireTableRowsInserted(this.list.size() - 2, this.list.size() - 1);
    }

    public void deleteTuple(int row) {
        this.list.remove(row);
        this.dirty = true;
        this.fireTableRowsDeleted(row, row);
    }
}

