/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import net.morilib.db.jdbc.BeanListResultSet;
import net.morilib.db.misc.ErrorBundle;

public class BeanResultSetMetaData
implements ResultSetMetaData {
    private List<String> columns;
    private Class<?> classe;

    BeanResultSetMetaData(Class<?> c, List<String> l) {
        this.classe = c;
        this.columns = l;
    }

    Class<?> _gettype(String columnLabel) throws SQLException {
        try {
            Method m = this.classe.getMethod("get" + BeanListResultSet._tolower(columnLabel), new Class[0]);
            return m.getReturnType();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw ErrorBundle.getDefault(10009, columnLabel);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    Class<?> _gettype(int c) throws SQLException {
        if (c < 1 || c > this.columns.size()) {
            throw ErrorBundle.getDefault(10045, c);
        }
        return this._gettype(this.columns.get(c - 1));
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this._gettype(column).isAssignableFrom(Number.class);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Class<Number> c = this._gettype(column);
        if (c.isAssignableFrom(Byte.class)) {
            return 4;
        }
        if (c.isAssignableFrom(Short.class)) {
            return 6;
        }
        if (c.isAssignableFrom(Integer.class)) {
            return 11;
        }
        if (c.isAssignableFrom(Long.class)) {
            return 20;
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column < 1 || column > this.columns.size()) {
            throw ErrorBundle.getDefault(10045, column);
        }
        return this.columns.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Class<Object> c = this._gettype(column);
        if (c.isAssignableFrom(Byte.class)) {
            return 4;
        }
        if (c.isAssignableFrom(Short.class)) {
            return 4;
        }
        if (c.isAssignableFrom(Integer.class)) {
            return 4;
        }
        if (c.isAssignableFrom(Long.class)) {
            return 4;
        }
        if (c.isAssignableFrom(String.class)) {
            return 12;
        }
        if (c.isAssignableFrom(BigDecimal.class)) {
            return 2;
        }
        return 12;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        Class<Object> c = this._gettype(column);
        if (c.isAssignableFrom(Byte.class)) {
            return "INTEGER";
        }
        if (c.isAssignableFrom(Short.class)) {
            return "INTEGER";
        }
        if (c.isAssignableFrom(Integer.class)) {
            return "INTEGER";
        }
        if (c.isAssignableFrom(Long.class)) {
            return "INTEGER";
        }
        if (c.isAssignableFrom(String.class)) {
            return "VARCHAR";
        }
        if (c.isAssignableFrom(BigDecimal.class)) {
            return "NUMERIC";
        }
        return "VARCHAR";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this._gettype(column).toString();
    }
}

