/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public final class LikeWildcard {
    private static int ALL = -1;
    private static int NONE = -2;
    private int[] chars;
    private List<Boolean> repeat;

    private LikeWildcard(int[] chars, List<Boolean> repeat) {
        this.chars = chars;
        this.repeat = repeat;
    }

    private boolean contains(int s, int c) {
        return this.chars[s] == ALL || this.chars[s] == c;
    }

    public boolean matches(CharSequence cs) {
        HashSet<Integer> ss = new HashSet<Integer>();
        HashSet<Integer> ad = new HashSet<Integer>();
        ss.add(0);
        int p = 0;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.contains(s, c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            ++p;
        }
        return ss.contains(this.chars.length - 1);
    }

    public int lookingAtLongest(CharSequence cs, int start) {
        TreeSet<Integer> ss = new TreeSet<Integer>();
        TreeSet<Integer> ad = new TreeSet<Integer>();
        ss.add(0);
        int r = ss.contains(this.chars.length - 1) ? start : -1;
        int p = start;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.contains(s, c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            if (ss.contains(this.chars.length - 1)) {
                r = p + 1;
            }
            ++p;
        }
        return r;
    }

    public int lookingAtShortest(CharSequence cs, int start) {
        TreeSet<Integer> ss = new TreeSet<Integer>();
        TreeSet<Integer> ad = new TreeSet<Integer>();
        ss.add(0);
        int p = start;
        while (p < cs.length()) {
            Iterator i = ss.iterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = (Integer)i.next();
                if (this.contains(s, c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.get(s).booleanValue()) continue;
                i.remove();
            }
            ss.addAll(ad);
            ad.clear();
            if (ss.isEmpty()) break;
            if (ss.contains(this.chars.length - 1)) {
                return p + 1;
            }
            ++p;
        }
        return -1;
    }

    int[] _findLongest(CharSequence cs, int s, int[] r) {
        int k = s;
        while (k <= cs.length()) {
            int l = this.lookingAtLongest(cs, k);
            if (l >= 0) {
                r[0] = k;
                r[1] = l;
                return r;
            }
            ++k;
        }
        return null;
    }

    int[] _findShortest(CharSequence cs, int s, int[] r) {
        int k = s;
        while (k <= cs.length()) {
            int l = this.lookingAtShortest(cs, k);
            if (l >= 0) {
                r[0] = k;
                r[1] = l;
                return r;
            }
            ++k;
        }
        return null;
    }

    public int lastLookingAtLongest(CharSequence s) {
        int[] a = new int[2];
        if (this._findLongest(s, 0, a) != null && a[1] == s.length()) {
            return a[0];
        }
        return -1;
    }

    public int lastLookingAtShortest(CharSequence s) {
        int[] a = new int[2];
        int i = s.length();
        while (i >= 0) {
            if (this._findLongest(s, i, a) != null && a[1] == s.length()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static LikeWildcard compile(CharSequence pt) {
        ArrayList<Integer> rl = new ArrayList<Integer>();
        ArrayList<Boolean> rp = new ArrayList<Boolean>();
        S1 stat = S1.INIT;
        boolean b = true;
        int p = 0;
        while (p < pt.length()) {
            char c = pt.charAt(p);
            block0 : switch (stat) {
                case INIT: {
                    switch (c) {
                        case '%': {
                            if (b) {
                                rp.add(true);
                            }
                            b = false;
                            break block0;
                        }
                        case '_': {
                            rl.add(ALL);
                            if (b) {
                                rp.add(false);
                            }
                            b = true;
                            break block0;
                        }
                        case '\\': {
                            stat = S1.ESC1;
                            break block0;
                        }
                    }
                    rl.add(Integer.valueOf(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case ESC1: {
                    stat = S1.INIT;
                    rl.add(Integer.valueOf(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                }
            }
            ++p;
        }
        if (b) {
            rp.add(false);
        }
        rl.add(NONE);
        int[] a = new int[rl.size()];
        int i = 0;
        while (i < rl.size()) {
            a[i] = (Integer)rl.get(i);
            ++i;
        }
        return new LikeWildcard(a, rp);
    }

    public static boolean matches(CharSequence pt, CharSequence cs) {
        return LikeWildcard.compile(pt).matches(cs);
    }

    private static enum S1 {
        INIT,
        ESC1;

    }
}

