/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.morilib.db.misc.HTMLTermException;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

class HTMLWriteTbls
implements HTMLHandler {
    private PrintWriter wr;
    private Iterator<RelationTuple> itr;
    private int tblno;
    private int colno;
    private int rowno;
    private SqlCreateTable table;
    private boolean tagw;
    private boolean putw;
    private RelationTuple tuple;
    private List<String> extra;
    private String name;
    private S stat;

    HTMLWriteTbls(Writer w, SqlCreateTable t, Iterable<RelationTuple> i) {
        this.wr = new PrintWriter(w);
        this.table = t;
        this.itr = i.iterator();
        this.tblno = 0;
        this.rowno = 0;
        this.name = t.getName();
        this.stat = S.INIT;
        this.putw = false;
        this.tagw = false;
    }

    private void puttagw() {
        if (this.tagw) {
            this.wr.print('>');
            this.tagw = false;
        }
    }

    private void putdata() throws SQLException {
        SqlColumnDefinition d = this.table.getColumnDefinitions().get(this.colno - 1);
        if (this.rowno < 2) {
            if (this.putw) {
                this.wr.print(d.getName());
                this.putw = false;
            }
        } else if (this.tuple != null) {
            this.wr.print(HTMLParser.escape(d.getType().string(this.tuple.get(d.getName()))));
        }
    }

    @Override
    public void string(String s) throws HTMLParseException {
        try {
            this.puttagw();
            if (this.stat == S.INIT || this.stat == S.TABLE_P) {
                this.wr.print(HTMLParser.escape(s));
            } else if (this.rowno < 2 || this.tuple != null) {
                if (this.stat == S.TD) {
                    this.putdata();
                } else {
                    this.wr.print(HTMLParser.escape(s));
                }
            }
        }
        catch (SQLException e) {
            throw new HTMLParseException(e);
        }
    }

    @Override
    public void startTag(String s) throws HTMLParseException {
        this.puttagw();
        switch (this.stat) {
            case INIT: {
                if (!s.equalsIgnoreCase("TABLE")) break;
                this.stat = S.TABLE_P;
                ++this.tblno;
                break;
            }
            case TABLE_P: {
                if (!this.name.equalsIgnoreCase("TABLE" + this.tblno)) break;
                this.stat = S.TABLE;
            }
            case TABLE: {
                if (!s.equalsIgnoreCase("TR")) break;
                this.colno = 0;
                this.tuple = ++this.rowno < 2 ? null : (this.itr.hasNext() ? this.itr.next() : null);
                this.stat = S.TR;
                break;
            }
            case TR: {
                if (!s.equalsIgnoreCase("TD") && !s.equalsIgnoreCase("TH")) break;
                this.extra = new ArrayList<String>();
                this.extra.add(s);
                ++this.colno;
                this.putw = true;
                this.stat = S.TD;
                break;
            }
            case TD: {
                if (s.equalsIgnoreCase(this.extra.get(0))) {
                    ++this.colno;
                    this.putw = true;
                    break;
                }
                if (s.equalsIgnoreCase("TR")) {
                    this.colno = 0;
                    this.tuple = ++this.rowno < 2 ? null : (this.itr.hasNext() ? this.itr.next() : null);
                    this.stat = S.TR;
                    break;
                }
                this.extra.add(s);
                this.stat = S.EXTRA;
                break;
            }
            case EXTRA: {
                this.extra.add(s);
            }
        }
        if (this.stat == S.INIT || this.stat == S.TABLE_P || this.rowno < 2 || this.tuple != null) {
            this.wr.format("<%s", HTMLParser.escape(s));
            this.tagw = true;
        }
    }

    @Override
    public void endTag(String s) throws HTMLParseException {
        try {
            this.puttagw();
            switch (this.stat) {
                case INIT: {
                    break;
                }
                case TABLE_P: {
                    this.stat = S.INIT;
                    break;
                }
                case TABLE: {
                    while (this.itr.hasNext()) {
                        this.tuple = this.itr.next();
                        Map<String, Object> m = this.tuple.toMap();
                        int j = 0;
                        this.wr.println("<tr>");
                        for (String t : m.keySet()) {
                            SqlColumnDefinition d = this.table.getColumnDefinitions().get(j++);
                            this.wr.format("  <td>%s</td>\n", d.getType().string(m.get(t)));
                        }
                        this.wr.println("</tr>");
                    }
                    this.stat = S.INIT;
                    break;
                }
                case TR: {
                    if (!s.equalsIgnoreCase("TR")) break;
                    this.stat = S.TABLE;
                    break;
                }
                case TD: {
                    if (s.equalsIgnoreCase(this.extra.get(0))) {
                        this.stat = S.TR;
                        break;
                    }
                    if (!s.equalsIgnoreCase("TR")) break;
                    this.stat = S.TABLE;
                    break;
                }
                case EXTRA: {
                    while (this.extra.size() > 0 && !this.extra.get(this.extra.size() - 1).equalsIgnoreCase(s)) {
                        this.extra.remove(this.extra.size() - 1);
                    }
                    if (this.extra.size() > 1) break;
                    if (this.extra.size() == 1) {
                        this.stat = S.TR;
                        break;
                    }
                    if (s.equalsIgnoreCase("TR")) {
                        this.stat = S.TABLE;
                        break;
                    }
                    if (!s.equalsIgnoreCase("TABLE")) break;
                    throw new HTMLTermException();
                }
            }
            if (this.stat == S.INIT || this.stat == S.TABLE_P || this.rowno < 2 || this.tuple != null) {
                this.wr.format("</%s>", HTMLParser.escape(s));
            }
        }
        catch (SQLException e) {
            throw new HTMLParseException(e);
        }
    }

    @Override
    public void tagAttribute(String k, String v) {
        if (this.rowno < 2 || this.tuple != null) {
            this.wr.format(" %s='%s'", HTMLParser.escape(k), HTMLParser.escape(v));
        }
        switch (this.stat) {
            case INIT: {
                break;
            }
            case TABLE_P: {
                if (!k.equalsIgnoreCase("ID") || !v.equalsIgnoreCase(this.name) && !this.name.equalsIgnoreCase("TABLE" + this.tblno)) break;
                this.stat = S.TABLE;
                break;
            }
            case TABLE: {
                break;
            }
            case TR: {
                break;
            }
            case TD: {
                break;
            }
        }
    }

    @Override
    public void meta(String s) throws HTMLParseException {
        this.wr.println(s);
    }

    @Override
    public void comment(String s) throws HTMLParseException {
        this.wr.format("<!--%s-->", s);
    }

    private static enum S {
        INIT,
        TABLE_P,
        TABLE,
        TR,
        TD,
        EXTRA;

    }
}

