/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.util.HashMap;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;

class XlsxTables
implements HTMLHandler {
    Map<String, Integer> map = new HashMap<String, Integer>();
    Map<Integer, String> inv = new HashMap<Integer, String>();
    private S stat = S.INIT;
    private String name;
    private int id;

    XlsxTables() {
    }

    String getSheet(String name) {
        return "sheet" + this.map.get(name) + ".xml";
    }

    private static HTMLParseException _geterr(int c, Object ... a) {
        return new HTMLParseException(ErrorBundle.getDefault(c, a));
    }

    @Override
    public void string(String s) throws HTMLParseException {
    }

    @Override
    public void startTag(String s) throws HTMLParseException {
        switch (this.stat) {
            case INIT: {
                if (!s.equals("workbook")) break;
                this.stat = S.WORKBOOK;
                break;
            }
            case WORKBOOK: {
                if (!s.equals("sheets")) break;
                this.stat = S.SHEETS;
                break;
            }
            case SHEETS: {
                if (!s.equals("sheet")) break;
                this.id = -1;
                this.stat = S.SHEET;
                break;
            }
        }
    }

    @Override
    public void endTag(String s) throws HTMLParseException {
        switch (this.stat) {
            case INIT: {
                break;
            }
            case WORKBOOK: {
                if (!s.equals("workbook")) break;
                this.stat = S.INIT;
                break;
            }
            case SHEETS: {
                if (!s.equals("sheets")) break;
                this.stat = S.WORKBOOK;
                break;
            }
            case SHEET: {
                if (!s.equals("sheet")) break;
                if (this.id < 0) {
                    throw XlsxTables._geterr(10046, new Object[0]);
                }
                this.map.put(this.name, this.id);
                this.inv.put(this.id, this.name);
                this.stat = S.SHEETS;
            }
        }
    }

    @Override
    public void tagAttribute(String k, String v) throws HTMLParseException {
        if (this.stat == S.SHEET) {
            if (k.equals("sheetId")) {
                try {
                    this.id = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    throw XlsxTables._geterr(10046, new Object[0]);
                }
            } else if (k.equals("name")) {
                this.name = v;
            }
        }
    }

    @Override
    public void meta(String s) throws HTMLParseException {
    }

    @Override
    public void comment(String s) throws HTMLParseException {
    }

    private static enum S {
        INIT,
        WORKBOOK,
        SHEETS,
        SHEET;

    }
}

