/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.misc.XlsxSharedString;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlColumnType;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

class XlsxWriteTable
implements HTMLHandler {
    private static final String COLS = "<col customWidth=\"1\" bestFit=\"1\" width=\"11.625\" max=\"%d\" min=\"%d\" />";
    private static final BigDecimal ML1 = BigDecimal.valueOf(86400000L);
    private static final BigDecimal SU1 = BigDecimal.valueOf(25569L);
    Collection<RelationTuple> tuples;
    SqlCreateTable table;
    String rid;
    private XlsxSharedString share;
    private PrintWriter wr;
    private boolean tagw;
    private S stat = S.INIT;
    private static final String ROW = "<row r=\"%d\" x14ac:dyDescent=\"0.15\" spans=\"1:%d\">";

    XlsxWriteTable(PrintWriter o, XlsxSharedString s, SqlCreateTable c, Collection<RelationTuple> t, String i) throws SQLException, IOException {
        this.wr = o;
        this.table = c;
        this.tuples = t;
        this.share = s;
        this.rid = i;
    }

    private void puttagw() {
        if (this.tagw) {
            this.wr.print('>');
            this.tagw = false;
        }
    }

    private static String colno(int a) throws SQLException {
        String v = "";
        if (a == 0) {
            return "A";
        }
        int x = a;
        while (x > 0) {
            v = String.valueOf(Character.toString((char)(x % 26 + 65))) + v;
            x /= 26;
        }
        return v;
    }

    private static String toSerialFromYMD(Date d) throws SQLException {
        try {
            BigDecimal b = new BigDecimal(d.getTime());
            b = b.divide(ML1, 6, RoundingMode.HALF_UP).add(SU1);
            return b.toString();
        }
        catch (NumberFormatException e) {
            throw ErrorBundle.getDefault(10046, new Object[0]);
        }
    }

    @Override
    public void string(String s) throws HTMLParseException {
        this.puttagw();
        switch (this.stat) {
            case INIT: 
            case WORKSHEET: {
                this.wr.print(HTMLParser.escape(s));
                break;
            }
        }
    }

    @Override
    public void startTag(String s) throws HTMLParseException {
        this.puttagw();
        switch (this.stat) {
            case INIT: {
                this.wr.format("<%s", HTMLParser.escape(s));
                this.tagw = true;
                if (!s.equals("worksheet")) break;
                this.stat = S.WORKSHEET;
                break;
            }
            case WORKSHEET: {
                this.wr.format("<%s", HTMLParser.escape(s));
                this.tagw = true;
                if (s.equals("sheetData")) {
                    this.stat = S.SHEET_DATA;
                    break;
                }
                if (!s.equals("cols")) break;
                this.stat = S.COLS;
                break;
            }
        }
    }

    private void _putSheets() throws HTMLParseException {
        int j = 1;
        try {
            List<SqlColumnDefinition> l = this.table.getColumnDefinitions();
            this.wr.format(ROW, 1, l.size());
            int i = 0;
            while (i < l.size()) {
                this.wr.format("<c r=\"%s1\" t=\"s\">", XlsxWriteTable.colno(i));
                this.wr.format("<v>%s</v></c>", this.share.getNumber(l.get(i).getName()));
                ++i;
            }
            this.wr.println("</row>");
            for (RelationTuple t : this.tuples) {
                int k = 0;
                this.wr.format(ROW, ++j, l.size());
                for (Object o : t.toMap().values()) {
                    if (o instanceof String) {
                        this.wr.format("<c r=\"%s%d\" t=\"s\">", XlsxWriteTable.colno(k++), j);
                        this.wr.format("<v>%s</v></c>", this.share.getNumber((String)o));
                        continue;
                    }
                    if (o instanceof Date) {
                        this.wr.format("<c r=\"%s%d\" s=\"1\">", XlsxWriteTable.colno(k++), j);
                        this.wr.format("<v>%s</v></c>", XlsxWriteTable.toSerialFromYMD((Date)o));
                        continue;
                    }
                    if (o instanceof Rational) {
                        SqlColumnType p = l.get(k - 1).getType();
                        this.wr.format("<c r=\"%s%d\">", XlsxWriteTable.colno(k++), j);
                        this.wr.format("<v>%s</v></c>", p.string(o));
                        continue;
                    }
                    throw ErrorBundle.getDefault(10046, new Object[0]);
                }
                this.wr.println("</row>");
            }
        }
        catch (SQLException e) {
            throw new HTMLParseException(e);
        }
    }

    private void _putCols() {
        this.wr.format(COLS, this.table.getColumnDefinitions().size(), this.table.getColumnDefinitions().size());
    }

    @Override
    public void endTag(String s) throws HTMLParseException {
        this.puttagw();
        switch (this.stat) {
            case INIT: {
                this.wr.format("</%s>", HTMLParser.escape(s));
                break;
            }
            case WORKSHEET: {
                this.wr.format("</%s>", HTMLParser.escape(s));
                if (!s.equals("worksheet")) break;
                this.stat = S.INIT;
                break;
            }
            case SHEET_DATA: {
                if (!s.equals("sheetData")) break;
                this._putSheets();
                this.wr.format("</%s>", HTMLParser.escape(s));
                this.stat = S.WORKSHEET;
                break;
            }
            case COLS: {
                if (!s.equals("cols")) break;
                this._putCols();
                this.wr.format("</%s>", HTMLParser.escape(s));
                this.stat = S.WORKSHEET;
            }
        }
    }

    @Override
    public void tagAttribute(String k, String v) throws HTMLParseException {
        switch (this.stat) {
            case INIT: 
            case WORKSHEET: {
                this.wr.format(" %s='%s'", HTMLParser.escape(k), HTMLParser.escape(v));
                break;
            }
        }
    }

    @Override
    public void meta(String s) throws HTMLParseException {
        this.wr.println(s);
    }

    @Override
    public void comment(String s) throws HTMLParseException {
        this.wr.format("<!--%s-->", s);
    }

    private static enum S {
        INIT,
        WORKSHEET,
        COLS,
        SHEET_DATA;

    }
}

