/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.delay;

import net.morilib.db.misc.Rational;

public class VarDelay extends OneValueDelay {

	Rational count, sum, sum2;

	public VarDelay() {
		count = sum = sum2 = Rational.ZERO;
	}

	public void add(Rational c) {
		sum   = sum.add(c);
		sum2  = sum2.add(c.multiply(c));
		count = count.add(Rational.ONE);
	}

	@Override
	public Object force() {
		Rational x;

		if(count.signum() > 0) {
			x = sum.divide(count);
			return sum2.divide(count).subtract(x.multiply(x));
		} else {
			return Rational.ZERO;
		}
	}

}
