/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class ProjectedTableRelation extends AbstractRelation {

	//
	Relation rel;
	List<String> columnNames;
	Collection<RelationTuple> data;

	/**
	 * 
	 * @param names
	 * @param data
	 */
	public ProjectedTableRelation(Relation r, List<String> names,
			Collection<RelationTuple> data) {
		rel = r;
		columnNames = new ArrayList<String>(names);
		this.data = data;
	}

	public List<SqlColumnDefinition> getColumnNames() {
		List<SqlColumnDefinition> l;

		l = new ArrayList<SqlColumnDefinition>();
		for(String s : columnNames) {
			l.add(getDefinition(s));
		}
		return l;
	}

	public RelationCursor iterator() {
		final Iterator<RelationTuple> i = data.iterator();

		return new RelationCursor() {

			@Override
			public boolean hasNext() {
				return i.hasNext();
			}

			@Override
			public RelationTuple next() {
				final RelationTuple t;

				t = i.next();
				return new RelationTuple() {

					public Object get(String n) throws SQLException {
						if(columnNames.contains(n)) {
							return t.get(n);
						} else {
							throw ErrorBundle.getDefault(10009, n);
						}
					}

					public RelationTuple copy() throws SQLException {
						return new DefaultRelationTuple(toMap());
					}

					public Map<String, Object> toMap() throws SQLException {
						Map<String, Object> m;

						m = new LinkedHashMap<String, Object>();
						for(String s : columnNames) {
							m.put(s, t.get(s));
						}
						return m;
					}

				};
			}

		};
	}

	@Override
	public SqlColumnDefinition getDefinition(String name) {
		for(int i = 0; i < columnNames.size(); i++) {
			if(columnNames.get(i).equals(name)) {
				return rel.getDefinition(
						rel.getColumnNames().get(i).getName());
			}
		}
		return null;
	}

}
