/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.account;

import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.keys.ECDSA;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.utils.Functions;

public class RemmeAccount
extends ECDSA
implements IRemmeKeys {
    public RemmeAccount(String privateKeyHex) {
        super(Functions.generateECDSAPrivateKey(Functions.hexToBytes(privateKeyHex)), null);
        this.familyName = RemmeFamilyName.ACCOUNT;
        this.address = Functions.generateAddress(this.familyName.getName(), this.publicKeyHex);
    }

    public RemmeAccount() {
        this(Functions.ecdsaPrivateKeyToHex(ECDSA.generateKeyPair().getPrivate()));
    }
}

