/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.api;

import com.github.arteam.simplejsonrpc.client.JsonRpcClient;
import com.github.arteam.simplejsonrpc.client.Transport;
import com.github.arteam.simplejsonrpc.client.builder.RequestBuilder;
import com.google.common.net.MediaType;
import io.remme.java.api.IRemmeApi;
import io.remme.java.api.NetworkConfig;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.utils.RemmeExecutorService;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class RemmeApi
implements IRemmeApi {
    private NetworkConfig networkConfig = new NetworkConfig();

    public RemmeApi(String nodeAddress, boolean sslMode) {
        this(new NetworkConfig(nodeAddress, sslMode));
    }

    public RemmeApi(NetworkConfig networkConfig) {
        Asserts.check((networkConfig != null ? 1 : 0) != 0, (String)"networkConfig should not be null!");
        Asserts.check((networkConfig.getNodeAddress() != null ? 1 : 0) != 0, (String)"nodeAddress should not be null!");
        this.networkConfig = networkConfig;
    }

    @Override
    public <T> Future<T> sendRequest(RemmeMethod method, Class<T> clazz) {
        return this.sendRequest(method, null, clazz);
    }

    @Override
    public <T> Future<T> sendRequest(RemmeMethod method, Object input, Class<T> clazz) {
        Map params = (Map)MAPPER.convertValue(input, Map.class);
        ExecutorService es = RemmeExecutorService.getInstance();
        RequestBuilder requestBuilder = this.getRequestBuilder(method);
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                requestBuilder = requestBuilder.param(name, params.get(name));
            }
        }
        RequestBuilder finalRequestBuilder = requestBuilder;
        return es.submit(() -> MAPPER.convertValue(finalRequestBuilder.execute(), clazz));
    }

    public String getURLForRequest() {
        return (this.networkConfig.isSslMode() ? "https://" : "http://") + this.networkConfig.getNodeAddress();
    }

    private RequestBuilder<Object> getRequestBuilder(RemmeMethod method) {
        return this.initClient().createRequest().method(method.getMethod()).id(Long.valueOf(Math.round(Math.random() * 100.0)));
    }

    private JsonRpcClient initClient() {
        return new JsonRpcClient(new Transport(){
            CloseableHttpClient httpClient = HttpClients.createDefault();

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @NotNull
            public String pass(@NotNull String request) throws IOException {
                HttpPost post = new HttpPost(RemmeApi.this.getURLForRequest());
                post.setEntity((HttpEntity)new StringEntity(request, Charsets.toCharset((String)"UTF-8")));
                post.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
                try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);){
                    if (httpResponse.getStatusLine().getStatusCode() == 200) {
                        String string = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charsets.toCharset((String)"UTF-8"));
                        return string;
                    }
                    throw new HttpException("Please check if your node running at " + RemmeApi.this.getURLForRequest());
                }
                catch (HttpException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static RemmeApiBuilder builder() {
        return new RemmeApiBuilder();
    }

    @Override
    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemmeApi)) {
            return false;
        }
        RemmeApi other = (RemmeApi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NetworkConfig this$networkConfig = this.getNetworkConfig();
        NetworkConfig other$networkConfig = other.getNetworkConfig();
        return !(this$networkConfig == null ? other$networkConfig != null : !((Object)this$networkConfig).equals(other$networkConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemmeApi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NetworkConfig $networkConfig = this.getNetworkConfig();
        result = result * 59 + ($networkConfig == null ? 43 : ((Object)$networkConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RemmeApi(networkConfig=" + this.getNetworkConfig() + ")";
    }

    public RemmeApi() {
    }

    public static class RemmeApiBuilder {
        private NetworkConfig networkConfig;

        RemmeApiBuilder() {
        }

        public RemmeApiBuilder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public RemmeApi build() {
            return new RemmeApi(this.networkConfig);
        }

        public String toString() {
            return "RemmeApi.RemmeApiBuilder(networkConfig=" + this.networkConfig + ")";
        }
    }
}

