/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.atomicswap;

import com.google.protobuf.ByteString;
import io.remme.java.api.IRemmeApi;
import io.remme.java.atomicswap.IRemmeSwap;
import io.remme.java.atomicswap.dto.SwapInfoDTO;
import io.remme.java.atomicswap.dto.SwapInitDTO;
import io.remme.java.atomicswap.dto.SwapRequestDTO;
import io.remme.java.enums.Patterns;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.protobuf.AtomicSwap;
import io.remme.java.protobuf.Transaction;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.transactionservice.IRemmeTransactionService;
import io.remme.java.transactionservice.dto.CreateTransactionDto;
import io.remme.java.utils.Functions;
import io.remme.java.utils.RemmeExecutorService;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class RemmeSwap
implements IRemmeSwap {
    private IRemmeApi remmeApi;
    private IRemmeTransactionService remmeTransactionService;
    private RemmeFamilyName familyName = RemmeFamilyName.SWAP;
    private String familyVersion = "0.1";
    private String zeroAddress = StringUtils.repeat((String)"0", (int)70);
    private String blockInfoNamespaceAddress = "00b10c00";
    private String blockInfoConfigAddress = "00b10c01" + StringUtils.repeat((String)"0", (int)62);
    private String settingsKeyGenesisOwners = Functions.generateSettingsAddress("remme.settings.genesis_owners");
    private String settingsSwapComission = Functions.generateSettingsAddress("remme.settings.swap_comission");

    private byte[] generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method method, ByteString data) {
        return Transaction.TransactionPayload.newBuilder().setMethod(method.getNumber()).setData(data).build().toByteArray();
    }

    private Addresses getAddresses(AtomicSwap.AtomicSwapMethod.Method method, String swapId, String receiverAddress) {
        String addresses = Functions.generateAddress(this.familyName.getName(), swapId);
        String[] inputs = null;
        String[] outputs = null;
        switch (method) {
            case INIT: {
                inputs = new String[]{addresses, this.settingsSwapComission, this.zeroAddress, this.blockInfoNamespaceAddress, this.blockInfoConfigAddress, this.settingsKeyGenesisOwners};
                outputs = new String[]{addresses, this.settingsSwapComission, this.zeroAddress, this.settingsKeyGenesisOwners};
                break;
            }
            case EXPIRE: {
                inputs = new String[]{addresses, this.zeroAddress, this.blockInfoNamespaceAddress, this.blockInfoConfigAddress, this.settingsKeyGenesisOwners};
                outputs = new String[]{addresses, this.zeroAddress, this.settingsKeyGenesisOwners};
                break;
            }
            case CLOSE: {
                inputs = new String[]{addresses, receiverAddress, this.zeroAddress, this.settingsKeyGenesisOwners};
                outputs = new String[]{addresses, receiverAddress, this.zeroAddress, this.settingsKeyGenesisOwners};
            }
        }
        Addresses io = inputs != null ? new Addresses(inputs, outputs) : new Addresses(new String[]{addresses}, new String[]{addresses});
        return io;
    }

    private Future<BaseTransactionResponse> createAndSendTransaction(byte[] transactionPayload, String[] inputs, String[] outputs) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            String transaction = this.remmeTransactionService.create(CreateTransactionDto.builder().familyName(this.familyName.getName()).familyVersion(this.familyVersion).inputs(inputs).outputs(outputs).payloadBytes(transactionPayload).build()).get();
            return this.remmeTransactionService.send(transaction).get();
        });
    }

    private void checkParameters(Parameters parameters) {
        try {
            Field[] fields;
            for (Field field : fields = parameters.getClass().getDeclaredFields()) {
                String value;
                Object result = field.get(parameters);
                if (!(result instanceof String) || (value = (String)result) == null) continue;
                if (StringUtils.isEmpty((CharSequence)value)) {
                    throw new RemmeValidationException("The " + field.getName() + " was missing in parameters");
                }
                if (value.matches(Patterns.SWAP_ID.getPattern())) continue;
                throw new RemmeValidationException("Given " + field.getName() + " is not valid");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public RemmeSwap(IRemmeApi remmeApi, IRemmeTransactionService remmeTransactionService) {
        this.remmeApi = remmeApi;
        this.remmeTransactionService = remmeTransactionService;
    }

    @Override
    public Future<BaseTransactionResponse> approve(String swapId) {
        this.checkParameters(new Parameters(swapId, null, null));
        AtomicSwap.AtomicSwapApprovePayload payload = AtomicSwap.AtomicSwapApprovePayload.newBuilder().setSwapId(swapId).build();
        byte[] transactionPayload = this.generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method.APPROVE, payload.toByteString());
        Addresses addresses = this.getAddresses(AtomicSwap.AtomicSwapMethod.Method.APPROVE, swapId, null);
        return this.createAndSendTransaction(transactionPayload, addresses.inputs, addresses.outputs);
    }

    @Override
    public Future<BaseTransactionResponse> close(String swapId, String secretKey) {
        this.checkParameters(new Parameters(swapId, null, secretKey));
        try {
            SwapInfoDTO infoDTO = this.getInfo(swapId).get();
            AtomicSwap.AtomicSwapClosePayload payload = AtomicSwap.AtomicSwapClosePayload.newBuilder().setSwapId(swapId).setSecretKey(secretKey).build();
            byte[] transactionPayload = this.generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method.CLOSE, payload.toByteString());
            Addresses addresses = this.getAddresses(AtomicSwap.AtomicSwapMethod.Method.CLOSE, swapId, infoDTO.getReceiver_address());
            return this.createAndSendTransaction(transactionPayload, addresses.inputs, addresses.outputs);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<BaseTransactionResponse> expire(String swapId) {
        this.checkParameters(new Parameters(swapId, null, null));
        AtomicSwap.AtomicSwapExpirePayload payload = AtomicSwap.AtomicSwapExpirePayload.newBuilder().setSwapId(swapId).build();
        byte[] transactionPayload = this.generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method.EXPIRE, payload.toByteString());
        Addresses addresses = this.getAddresses(AtomicSwap.AtomicSwapMethod.Method.EXPIRE, swapId, null);
        return this.createAndSendTransaction(transactionPayload, addresses.inputs, addresses.outputs);
    }

    @Override
    public Future<SwapInfoDTO> getInfo(String swapId) {
        this.checkParameters(new Parameters(swapId, null, null));
        return this.remmeApi.sendRequest(RemmeMethod.ATOMIC_SWAP, new SwapRequestDTO(swapId), SwapInfoDTO.class);
    }

    @Override
    public Future<String> getPublicKey() {
        return this.remmeApi.sendRequest(RemmeMethod.ATOMIC_SWAP_PUBLIC_KEY, String.class);
    }

    @Override
    public Future<BaseTransactionResponse> init(SwapInitDTO data) {
        AtomicSwap.AtomicSwapInitPayload payload = AtomicSwap.AtomicSwapInitPayload.newBuilder().setSwapId(data.getSwapId()).setAmount(data.getAmount()).setCreatedAt(data.getCreatedAt()).setEmailAddressEncryptedByInitiator(data.getEmailAddressEncryptedByInitiator() == null ? "" : data.getEmailAddressEncryptedByInitiator()).setReceiverAddress(data.getReceiverAddress()).setSecretLockBySolicitor(data.getSecretLockBySolicitor() == null ? "" : data.getSecretLockBySolicitor()).setSenderAddressNonLocal(data.getSenderAddressNonLocal()).build();
        byte[] transactionPayload = this.generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method.INIT, payload.toByteString());
        Addresses addresses = this.getAddresses(AtomicSwap.AtomicSwapMethod.Method.INIT, data.getSwapId(), null);
        return this.createAndSendTransaction(transactionPayload, addresses.inputs, addresses.outputs);
    }

    @Override
    public Future<BaseTransactionResponse> setSecretLock(String swapId, String secretLock) {
        this.checkParameters(new Parameters(swapId, secretLock, null));
        AtomicSwap.AtomicSwapSetSecretLockPayload payload = AtomicSwap.AtomicSwapSetSecretLockPayload.newBuilder().setSwapId(swapId).setSecretLock(secretLock).build();
        byte[] transactionPayload = this.generateTransactionPayload(AtomicSwap.AtomicSwapMethod.Method.SET_SECRET_LOCK, payload.toByteString());
        Addresses addresses = this.getAddresses(AtomicSwap.AtomicSwapMethod.Method.SET_SECRET_LOCK, swapId, null);
        return this.createAndSendTransaction(transactionPayload, addresses.inputs, addresses.outputs);
    }

    private class Parameters {
        public String swapId;
        public String secretLock;
        public String secretKey;

        public Parameters(String swapId, String secretLock, String secretKey) {
            this.swapId = swapId;
            this.secretLock = secretLock;
            this.secretKey = secretKey;
        }

        public Parameters() {
        }
    }

    private class Addresses {
        String[] inputs;
        String[] outputs;

        public Addresses(String[] inputs, String[] outputs) {
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public Addresses() {
        }
    }
}

