/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.blockchaininfo.dto.query;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.remme.java.blockchaininfo.dto.query.BaseQuery;
import io.remme.java.enums.Patterns;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeValidationException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BaseQueryRequest {
    private String head;
    private String start;
    private Integer limit;
    private String reverse;
    @JsonProperty(value="family_name")
    private RemmeFamilyName familyName;

    public BaseQueryRequest(BaseQuery query) {
        this.head = query.getHead();
        this.setStart(query.getStart());
        this.limit = query.getLimit();
        this.setReverse(query.getReverse());
        this.familyName = query.getFamilyName();
    }

    @JsonProperty(value="reverse")
    public void setReverse(Object reverse) {
        if (reverse != null) {
            if (reverse instanceof Boolean) {
                this.reverse = String.valueOf(reverse);
            }
            if (reverse instanceof String) {
                this.reverse = (String)reverse;
            }
        }
    }

    @JsonProperty(value="head")
    public void setHead(String head) {
        if (head != null && !head.matches("[a-f0-9]{128}")) {
            throw new RemmeValidationException("Parameter 'head' is not valid");
        }
        this.head = head;
    }

    @JsonProperty(value="start")
    public void setStart(Object start) {
        if (start != null) {
            if (start instanceof String && (((String)start).matches("^0x[a-f0-9]{16}$") || ((String)start).matches("^[a-f0-9]{128}$") || ((String)start).matches(Patterns.ADDRESS.getPattern()))) {
                this.start = (String)start;
            } else if (start instanceof Integer) {
                this.start = String.valueOf(start);
            } else {
                throw new RemmeValidationException("Parameter 'start' is not valid");
            }
        }
    }

    public static BaseQueryRequestBuilder builder() {
        return new BaseQueryRequestBuilder();
    }

    public String getHead() {
        return this.head;
    }

    public String getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getReverse() {
        return this.reverse;
    }

    public RemmeFamilyName getFamilyName() {
        return this.familyName;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setFamilyName(RemmeFamilyName familyName) {
        this.familyName = familyName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseQueryRequest)) {
            return false;
        }
        BaseQueryRequest other = (BaseQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$head = this.getHead();
        String other$head = other.getHead();
        if (this$head == null ? other$head != null : !this$head.equals(other$head)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$reverse = this.getReverse();
        String other$reverse = other.getReverse();
        if (this$reverse == null ? other$reverse != null : !this$reverse.equals(other$reverse)) {
            return false;
        }
        RemmeFamilyName this$familyName = this.getFamilyName();
        RemmeFamilyName other$familyName = other.getFamilyName();
        return !(this$familyName == null ? other$familyName != null : !((Object)((Object)this$familyName)).equals((Object)other$familyName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $head = this.getHead();
        result = result * 59 + ($head == null ? 43 : $head.hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $reverse = this.getReverse();
        result = result * 59 + ($reverse == null ? 43 : $reverse.hashCode());
        RemmeFamilyName $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : ((Object)((Object)$familyName)).hashCode());
        return result;
    }

    public String toString() {
        return "BaseQueryRequest(head=" + this.getHead() + ", start=" + this.getStart() + ", limit=" + this.getLimit() + ", reverse=" + this.getReverse() + ", familyName=" + (Object)((Object)this.getFamilyName()) + ")";
    }

    public BaseQueryRequest(String head, String start, Integer limit, String reverse, RemmeFamilyName familyName) {
        this.head = head;
        this.start = start;
        this.limit = limit;
        this.reverse = reverse;
        this.familyName = familyName;
    }

    public BaseQueryRequest() {
    }

    public static class BaseQueryRequestBuilder {
        private String head;
        private String start;
        private Integer limit;
        private String reverse;
        private RemmeFamilyName familyName;

        BaseQueryRequestBuilder() {
        }

        public BaseQueryRequestBuilder head(String head) {
            this.head = head;
            return this;
        }

        public BaseQueryRequestBuilder start(String start) {
            this.start = start;
            return this;
        }

        public BaseQueryRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public BaseQueryRequestBuilder reverse(String reverse) {
            this.reverse = reverse;
            return this;
        }

        public BaseQueryRequestBuilder familyName(RemmeFamilyName familyName) {
            this.familyName = familyName;
            return this;
        }

        public BaseQueryRequest build() {
            return new BaseQueryRequest(this.head, this.start, this.limit, this.reverse, this.familyName);
        }

        public String toString() {
            return "BaseQueryRequest.BaseQueryRequestBuilder(head=" + this.head + ", start=" + this.start + ", limit=" + this.limit + ", reverse=" + this.reverse + ", familyName=" + (Object)((Object)this.familyName) + ")";
        }
    }
}

