/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.certificate.dto;

import io.remme.java.api.NetworkConfig;
import io.remme.java.certificate.dto.ICertificateTransactionResponse;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.RSA;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.utils.Certificate;

public class CertificateTransactionResponse
extends BaseTransactionResponse
implements ICertificateTransactionResponse {
    private IRemmeKeys keys;
    private Certificate certificate;

    public CertificateTransactionResponse(String socketAddress, Boolean sslMode, String batchId, Certificate certificate) {
        this(new NetworkConfig(socketAddress, sslMode), batchId, certificate);
    }

    public CertificateTransactionResponse(NetworkConfig networkConfig, String batchId, Certificate certificate) {
        super(networkConfig, batchId);
        this.certificate = certificate;
        this.keys = new RSA(this.certificate.getPublicKey(), this.certificate.getPrivateKey());
    }

    @Override
    public String sign(String data, RSASignaturePadding rsaSignaturePadding) {
        return this.keys.sign(data, rsaSignaturePadding);
    }

    @Override
    public String sign(String data) {
        return this.keys.sign(data, RSASignaturePadding.PSS);
    }

    @Override
    public boolean verify(String data, String signature, RSASignaturePadding rsaSignaturePadding) {
        return this.keys.verify(data, signature, rsaSignaturePadding);
    }

    @Override
    public boolean verify(String data, String signature) {
        return this.keys.verify(data, signature, RSASignaturePadding.PSS);
    }

    @Override
    public IRemmeKeys getKeys() {
        return this.keys;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }
}

