/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.keys;

import io.remme.java.enums.KeyType;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.dto.KeyDTO;
import io.remme.java.utils.Functions;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.util.Asserts;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class ECDSA
extends KeyDTO
implements IRemmeKeys {
    private static final X9ECParameters curve = SECNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters domain = new ECDomainParameters(curve.getCurve(), curve.getG(), curve.getN(), curve.getH());
    private static final BigInteger HALF_CURVE_ORDER = curve.getN().shiftRight(1);

    public ECDSA(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey != null && publicKey != null) {
            Asserts.check((boolean)(privateKey instanceof BCECPrivateKey), (String)"Private Key should be instance of BCECPrivateKey");
            Asserts.check((boolean)(publicKey instanceof BCECPublicKey), (String)"Public Key should be instance of BCECPublicKey");
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        } else if (privateKey != null) {
            Asserts.check((boolean)(privateKey instanceof BCECPrivateKey), (String)"Private Key should be instance of BCECPrivateKey");
            this.privateKey = privateKey;
            this.publicKey = ECDSA.derivePubKeyFromPrivKey((BCECPrivateKey)this.privateKey);
        } else if (publicKey != null) {
            Asserts.check((boolean)(publicKey instanceof BCECPublicKey), (String)"Public Key should be instance of BCECPublicKey");
            this.publicKey = publicKey;
        }
        this.publicKeyHex = Functions.ecdsaPublicKeyToHex(this.publicKey, true);
        if (privateKey != null) {
            this.privateKeyHex = Functions.ecdsaPrivateKeyToHex(this.privateKey);
        }
        this.publicKeyBase64 = Base64.encodeBase64String((byte[])this.publicKeyHex.getBytes(StandardCharsets.UTF_8));
        this.address = Functions.generateAddress(this.familyName.getName(), this.publicKeyHex);
        this.keyType = KeyType.ECDSA.getType();
    }

    public static String getAddressFromPublicKey(PublicKey publicKey) {
        Asserts.check((boolean)(publicKey instanceof BCECPublicKey), (String)"Public Key should be instance of BCECPublicKey");
        return Functions.generateAddress(RemmeFamilyName.PUBLIC_KEY.getName(), Functions.ecdsaPublicKeyToHex(publicKey, true));
    }

    public static KeyPair generateKeyPair() {
        byte[] privKey = ECDSA.createNewPrivateKey();
        while (privKey.length != 32) {
            privKey = ECDSA.createNewPrivateKey();
        }
        byte[] pubKey = ECDSA.getPublicFor(privKey);
        PrivateKey privateKey = Functions.generateECDSAPrivateKey(privKey);
        PublicKey publicKey = Functions.getECDSAPublicKeyFromBytes(pubKey);
        return new KeyPair(publicKey, privateKey);
    }

    private static byte[] getPublicFor(byte[] privateKey) {
        return curve.getG().multiply(new BigInteger(privateKey)).getEncoded(true);
    }

    private static byte[] createNewPrivateKey() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(domain, new SecureRandom());
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        return privParams.getD().toByteArray();
    }

    private static PublicKey derivePubKeyFromPrivKey(BCECPrivateKey definingKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            BigInteger d = definingKey.getD();
            ECParameterSpec ecSpec = definingKey.getParameters();
            ECPoint Q = definingKey.getParameters().getG().multiply(d);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(Q, ecSpec);
            return keyFactory.generatePublic((KeySpec)pubSpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String sign(String dataString) {
        if (this.privateKey == null) {
            throw new RemmeKeyException("PrivateKey is not provided!");
        }
        byte[] dataHash = DigestUtils.sha256((byte[])dataString.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])this.sign(dataHash, Functions.hexToBytes(this.privateKeyHex)));
    }

    @Override
    public String sign(byte[] data) {
        if (this.privateKey == null) {
            throw new RemmeKeyException("PrivateKey is not provided!");
        }
        byte[] dataHash = DigestUtils.sha256((byte[])data);
        return Hex.encodeHexString((byte[])this.sign(dataHash, Functions.hexToBytes(this.privateKeyHex)));
    }

    @Override
    public String sign(String data, RSASignaturePadding padding) {
        return this.sign(data);
    }

    @Override
    public String sign(byte[] data, RSASignaturePadding padding) {
        return this.sign(data);
    }

    @Override
    public boolean verify(String signatureHex, String data) {
        return this.verify(signatureHex, data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean verify(String signature, String data, RSASignaturePadding padding) {
        return this.verify(signature, data);
    }

    @Override
    public boolean verify(String signatureHex, byte[] data) {
        try {
            byte[] tokenSignature = Hex.decodeHex((String)signatureHex);
            byte[] dataHash = DigestUtils.sha256((byte[])data);
            return this.verify(dataHash, tokenSignature, Hex.decodeHex((String)this.publicKeyHex));
        }
        catch (DecoderException e) {
            return false;
        }
    }

    @Override
    public boolean verify(String signature, byte[] data, RSASignaturePadding padding) {
        return this.verify(signature, data);
    }

    private byte[] sign(byte[] hash, byte[] privateKey) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        signer.init(true, (CipherParameters)new ECPrivateKeyParameters(new BigInteger(privateKey), domain));
        BigInteger[] signature = signer.generateSignature(hash);
        byte[] r1 = signature[0].toByteArray();
        byte[] s1 = this.toCanonicalS(signature[1]).toByteArray();
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        if (r1.length > 32) {
            System.arraycopy(r1, 1, r, 0, r.length);
        } else if (r1.length < 32) {
            System.arraycopy(r1, 0, r, 1, r1.length);
        } else {
            r = r1;
        }
        if (s1.length > 32) {
            System.arraycopy(s1, 1, s, 0, s.length);
        } else if (s1.length < 32) {
            System.arraycopy(s1, 0, s, 1, s1.length);
        } else {
            s = s1;
        }
        byte[] rs = new byte[r.length + s.length];
        System.arraycopy(r, 0, rs, 0, r.length);
        System.arraycopy(s, 0, rs, r.length, s.length);
        return rs;
    }

    private BigInteger toCanonicalS(BigInteger s) {
        if (s.compareTo(HALF_CURVE_ORDER) <= 0) {
            return s;
        }
        return curve.getN().subtract(s);
    }

    private boolean verify(byte[] hash, byte[] signature, byte[] publicKey) {
        ECDSASigner signer = new ECDSASigner();
        signer.init(false, (CipherParameters)new ECPublicKeyParameters(curve.getCurve().decodePoint(publicKey), domain));
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signature, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signature, 32, 64));
        if (!signer.verifySignature(hash, r, s)) {
            System.out.println("Something wrong with signature");
        }
        return signer.verifySignature(hash, r, s);
    }
}

