/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.keys;

import io.remme.java.enums.KeyType;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.dto.GenerateOptions;
import io.remme.java.keys.dto.KeyDTO;
import io.remme.java.utils.Functions;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.util.Asserts;

public class RSA
extends KeyDTO
implements IRemmeKeys {
    private static final Integer RSA_KEY_SIZE = 2048;

    public RSA(PublicKey publicKey, PrivateKey privateKey) {
        if (privateKey != null && publicKey != null) {
            Asserts.check((boolean)(privateKey instanceof RSAPrivateKey), (String)"Private Key should be instance of RSAPrivateKey");
            Asserts.check((boolean)(publicKey instanceof RSAPublicKey), (String)"Public Key should be instance of RSAPublicKey");
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        } else if (privateKey != null) {
            Asserts.check((boolean)(privateKey instanceof RSAPrivateKey), (String)"Private Key should be instance of RSAPrivateKey");
            this.privateKey = privateKey;
            try {
                RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)this.privateKey;
                RSAPublicKeySpec spec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent());
                KeyFactory factory = KeyFactory.getInstance(KeyType.RSA.name());
                this.publicKey = factory.generatePublic(spec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (publicKey != null) {
            Asserts.check((boolean)(publicKey instanceof RSAPublicKey), (String)"Public Key should be instance of RSAPublicKey");
            this.publicKey = publicKey;
        }
        this.publicKeyPem = Functions.publicKeyToPem(this.publicKey);
        if (this.privateKey != null) {
            this.privateKeyPem = Functions.privateKeyToPem(this.privateKey);
        }
        this.publicKeyBase64 = Base64.encodeBase64String((byte[])this.publicKeyPem.getBytes(StandardCharsets.UTF_8));
        this.address = Functions.generateAddress(this.familyName.getName(), this.publicKey.getEncoded());
        this.keyType = KeyType.RSA.getType();
    }

    public static String getAddressFromPublicKey(PublicKey publicKey) {
        Asserts.check((boolean)(publicKey instanceof RSAPublicKey), (String)"Public Key should be instance of RSAPublicKey");
        return Functions.generateAddress(RemmeFamilyName.PUBLIC_KEY.getName(), publicKey.getEncoded());
    }

    private Integer calculateSaltLength(MessageDigest md) {
        int emlen = (int)Math.ceil(RSA_KEY_SIZE / 8);
        return emlen - md.getDigestLength() - 2;
    }

    @Override
    public String sign(byte[] data, RSASignaturePadding rsaSignaturePadding) {
        try {
            if (this.privateKey == null) {
                throw new RemmeKeyException("PrivateKey is not provided!");
            }
            rsaSignaturePadding = rsaSignaturePadding != null ? rsaSignaturePadding : RSASignaturePadding.PSS;
            switch (rsaSignaturePadding) {
                case PSS: {
                    MessageDigest hashEngine = MessageDigest.getInstance("SHA-256");
                    hashEngine.update(data);
                    int saltLength = this.calculateSaltLength(hashEngine);
                    PSSParameterSpec pssParamSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, saltLength, 1);
                    Signature pss = Signature.getInstance("SHA256withRSAandMGF1");
                    pss.setParameter(pssParamSpec);
                    pss.initSign(this.privateKey);
                    pss.update(data);
                    return Hex.encodeHexString((byte[])pss.sign());
                }
                case PKCS1v15: {
                    Signature pkcs1v15 = Signature.getInstance("SHA256withRSA");
                    pkcs1v15.initSign(this.privateKey);
                    pkcs1v15.update(data);
                    return Hex.encodeHexString((byte[])pkcs1v15.sign());
                }
            }
            throw new IllegalArgumentException("Unknown padding: " + rsaSignaturePadding.name());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String sign(byte[] data) {
        return this.sign(data, RSASignaturePadding.PSS);
    }

    @Override
    public boolean verify(String signature, byte[] data, RSASignaturePadding rsaSignaturePadding) {
        try {
            byte[] signatureBytes = Hex.decodeHex((String)signature);
            switch (rsaSignaturePadding) {
                case PSS: {
                    MessageDigest hashEngine = MessageDigest.getInstance("SHA-256");
                    hashEngine.update(data);
                    int saltLength = this.calculateSaltLength(hashEngine);
                    PSSParameterSpec pssParamSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, saltLength, 1);
                    Signature pss = Signature.getInstance("SHA256withRSAandMGF1");
                    pss.setParameter(pssParamSpec);
                    pss.initVerify(this.publicKey);
                    pss.update(data);
                    return pss.verify(signatureBytes);
                }
                case PKCS1v15: {
                    Signature pkcs1v15 = Signature.getInstance("SHA256withRSA");
                    pkcs1v15.initVerify(this.publicKey);
                    pkcs1v15.update(data);
                    return pkcs1v15.verify(signatureBytes);
                }
            }
            throw new IllegalArgumentException("Unknown padding: " + rsaSignaturePadding.name());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean verify(String signature, byte[] data) {
        return this.verify(signature, data, RSASignaturePadding.PSS);
    }

    @Override
    public String sign(String dataString, RSASignaturePadding rsaSignaturePadding) {
        return this.sign(dataString.getBytes(StandardCharsets.UTF_8), rsaSignaturePadding);
    }

    @Override
    public String sign(String data) {
        return this.sign(data, RSASignaturePadding.PSS);
    }

    @Override
    public boolean verify(String signature, String dataString, RSASignaturePadding rsaSignaturePadding) {
        return this.verify(signature, dataString.getBytes(StandardCharsets.UTF_8), rsaSignaturePadding);
    }

    @Override
    public boolean verify(String signature, String data) {
        return this.verify(signature, data, RSASignaturePadding.PSS);
    }

    public static KeyPair generateKeyPair(GenerateOptions options) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(KeyType.RSA.name());
            generator.initialize(options != null && options.getRsaKeySize() != null ? options.getRsaKeySize() : RSA_KEY_SIZE);
            return generator.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

