/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.transactionservice;

import com.google.protobuf.ByteString;
import io.remme.java.account.RemmeAccount;
import io.remme.java.api.IRemmeApi;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.transactionservice.IRemmeTransactionService;
import io.remme.java.transactionservice.dto.CreateTransactionDto;
import io.remme.java.transactionservice.dto.SendTransactionDto;
import io.remme.java.utils.RemmeExecutorService;
import io.remme.java.utils.models.NodeConfigRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import sawtooth.sdk.protobuf.Transaction;
import sawtooth.sdk.protobuf.TransactionHeader;

public class RemmeTransactionService
implements IRemmeTransactionService {
    private IRemmeApi remmeApi;
    private RemmeAccount remmeAccount;

    public RemmeTransactionService(IRemmeApi remmeApi, RemmeAccount remmeAccount) {
        this.remmeApi = remmeApi;
        this.remmeAccount = remmeAccount;
    }

    @Override
    public Future<String> create(CreateTransactionDto settings) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            try {
                NodeConfigRequest nodeConfig = this.remmeApi.sendRequest(RemmeMethod.NODE_CONFIG, NodeConfigRequest.class).get();
                ArrayList<String> outputs = new ArrayList<String>(Arrays.asList(settings.getOutputs()));
                outputs.add(this.remmeAccount.getAddress());
                ArrayList<String> inputs = new ArrayList<String>(Arrays.asList(settings.getInputs()));
                inputs.add(this.remmeAccount.getAddress());
                TransactionHeader transactionHeader = TransactionHeader.newBuilder().setFamilyName(settings.getFamilyName()).setFamilyVersion(settings.getFamilyVersion()).setSignerPublicKey(this.remmeAccount.getPublicKeyHex()).setNonce(DigestUtils.sha512Hex((String)String.valueOf(Math.floor(Math.random() * 1000.0)))).setBatcherPublicKey(nodeConfig.getNode_public_key()).setPayloadSha512(DigestUtils.sha512Hex((byte[])settings.getPayloadBytes())).addAllOutputs(outputs).addAllInputs(inputs).build();
                String signature = this.remmeAccount.sign(transactionHeader.toByteArray());
                Transaction transaction = Transaction.newBuilder().setHeader(transactionHeader.toByteString()).setHeaderSignature(signature).setPayload(ByteString.copyFrom((byte[])settings.getPayloadBytes())).build();
                return Base64.encodeBase64String((byte[])transaction.toByteArray());
            }
            catch (Exception e) {
                throw new RemmeValidationException(e);
            }
        });
    }

    @Override
    public Future<BaseTransactionResponse> send(String transaction) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            try {
                SendTransactionDto requestPayload = new SendTransactionDto(transaction);
                String batchId = this.remmeApi.sendRequest(RemmeMethod.TRANSACTION, requestPayload, String.class).get();
                return new BaseTransactionResponse(this.remmeApi.getNetworkConfig(), batchId);
            }
            catch (Exception e) {
                throw new RemmeValidationException(e);
            }
        });
    }
}

