/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.utils;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;

public class Certificate {
    X509Certificate cert;
    PrivateKey privateKey;

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public static CertificateBuilder builder() {
        return new CertificateBuilder();
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X509Certificate this$cert = this.getCert();
        X509Certificate other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !((Object)this$cert).equals(other$cert)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Certificate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : ((Object)$cert).hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    public String toString() {
        return "Certificate(cert=" + this.getCert() + ", privateKey=" + this.getPrivateKey() + ")";
    }

    public Certificate(X509Certificate cert, PrivateKey privateKey) {
        this.cert = cert;
        this.privateKey = privateKey;
    }

    public Certificate() {
    }

    public static class CertificateBuilder {
        private X509Certificate cert;
        private PrivateKey privateKey;

        CertificateBuilder() {
        }

        public CertificateBuilder cert(X509Certificate cert) {
            this.cert = cert;
            return this;
        }

        public CertificateBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Certificate build() {
            return new Certificate(this.cert, this.privateKey);
        }

        public String toString() {
            return "Certificate.CertificateBuilder(cert=" + this.cert + ", privateKey=" + this.privateKey + ")";
        }
    }
}

