/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.arteam.simplejsonrpc.core.domain.ErrorMessage;
import io.remme.java.api.NetworkConfig;
import io.remme.java.atomicswap.dto.SwapInfoDTO;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeSocketException;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.websocket.IRemmeWebSocket;
import io.remme.java.websocket.SocketEventListener;
import io.remme.java.websocket.dto.ErrorFromEvent;
import io.remme.java.websocket.dto.JsonRpcRequest;
import io.remme.java.websocket.dto.JsonRpcResponse;
import io.remme.java.websocket.dto.JsonRpcResult;
import io.remme.java.websocket.dto.RemmeRequestParams;
import io.remme.java.websocket.dto.batch.BatchInfoDTO;
import io.remme.java.websocket.dto.batch.BatchStatus;
import io.remme.java.websocket.dto.block.BlockInfoDTO;
import io.remme.java.websocket.dto.transfer.TransferInfoDTO;
import io.remme.java.websocket.enums.RemmeEvents;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class RemmeWebSocket
implements IRemmeWebSocket {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private NetworkConfig networkConfig;
    private static final Map<RemmeEvents, Class<?>> EVENT_MAP = new HashMap();
    protected WebSocketClient client;
    protected RemmeRequestParams data;

    public RemmeWebSocket(String nodeAddress, boolean sslMode, RemmeRequestParams params) {
        this(new NetworkConfig(nodeAddress, sslMode), params);
    }

    public RemmeWebSocket(NetworkConfig networkConfig, RemmeRequestParams params) {
        this.networkConfig = networkConfig;
        this.data = params;
    }

    private String getSubscribeUrl() {
        return (this.networkConfig.isSslMode() ? "wss://" : "ws://") + this.networkConfig.getNodeAddress() + "/";
    }

    private String getSocketQuery() {
        return this.getSocketQuery(true);
    }

    private String getSocketQuery(boolean subscribe) {
        if (this.data == null) {
            throw new Error("Data for subscribe was not provided");
        }
        RemmeMethod method = subscribe ? RemmeMethod.SUBSCRIBE : RemmeMethod.UNSUBSCRIBE;
        try {
            return MAPPER.writeValueAsString((Object)new JsonRpcRequest(method, this.data));
        }
        catch (JsonProcessingException e) {
            throw new RemmeSocketException(e);
        }
    }

    private void sendAnError(Object error, SocketEventListener listener) {
        this.closeWebSocket();
        listener.callback(error, null);
    }

    @Override
    public void connectToWebSocket(final SocketEventListener listener) {
        try {
            if (this.client != null && this.client.isOpen()) {
                this.client.close();
            }
            this.client = new WebSocketClient(new URI(this.getSubscribeUrl())){

                public void onOpen(ServerHandshake serverHandshake) {
                    this.send(RemmeWebSocket.this.getSocketQuery());
                }

                public void onMessage(String message) {
                    try {
                        JsonRpcResponse response = (JsonRpcResponse)MAPPER.readValue(message, JsonRpcResponse.class);
                        if (response.getError() != null) {
                            RemmeWebSocket.this.sendAnError(response.getError(), listener);
                            return;
                        }
                        if (response.getResult() != null && !(response.getResult() instanceof String)) {
                            BatchInfoDTO batchInfo;
                            JsonRpcResult result = (JsonRpcResult)MAPPER.convertValue(response.getResult(), JsonRpcResult.class);
                            if (RemmeEvents.BATCH.equals((Object)result.getEvent_type()) && (batchInfo = (BatchInfoDTO)MAPPER.convertValue(result.getAttributes(), BatchInfoDTO.class)).getStatus().equals((Object)BatchStatus.INVALID)) {
                                RemmeWebSocket.this.sendAnError(new ErrorFromEvent(batchInfo), listener);
                                return;
                            }
                            listener.callback(null, MAPPER.convertValue(result.getAttributes(), (Class)EVENT_MAP.get((Object)result.getEvent_type())));
                        }
                    }
                    catch (Exception e) {
                        throw new RemmeSocketException(e);
                    }
                }

                public void onClose(int code, String reason, boolean remote) {
                    if (code != 1000) {
                        listener.callback(new ErrorMessage(code, reason), null);
                    }
                }

                public void onError(Exception e) {
                    throw new RemmeSocketException(e);
                }
            };
            this.client.connect();
        }
        catch (URISyntaxException e) {
            throw new RemmeSocketException(e);
        }
    }

    @Override
    public void closeWebSocket() {
        if (this.client == null || this.client.isClosed()) {
            throw new RemmeValidationException("WebSocket is not running");
        }
        if (WebSocket.READYSTATE.OPEN.equals((Object)this.client.getReadyState())) {
            this.client.send(this.getSocketQuery(false));
        }
        this.client.close();
        this.client = null;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public RemmeRequestParams getData() {
        return this.data;
    }

    public void setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public void setClient(WebSocketClient client) {
        this.client = client;
    }

    public void setData(RemmeRequestParams data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemmeWebSocket)) {
            return false;
        }
        RemmeWebSocket other = (RemmeWebSocket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NetworkConfig this$networkConfig = this.getNetworkConfig();
        NetworkConfig other$networkConfig = other.getNetworkConfig();
        if (this$networkConfig == null ? other$networkConfig != null : !((Object)this$networkConfig).equals(other$networkConfig)) {
            return false;
        }
        WebSocketClient this$client = this.getClient();
        WebSocketClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        RemmeRequestParams this$data = this.getData();
        RemmeRequestParams other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemmeWebSocket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NetworkConfig $networkConfig = this.getNetworkConfig();
        result = result * 59 + ($networkConfig == null ? 43 : ((Object)$networkConfig).hashCode());
        WebSocketClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        RemmeRequestParams $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "RemmeWebSocket(networkConfig=" + this.getNetworkConfig() + ", client=" + this.getClient() + ", data=" + this.getData() + ")";
    }

    public RemmeWebSocket(NetworkConfig networkConfig, WebSocketClient client, RemmeRequestParams data) {
        this.networkConfig = networkConfig;
        this.client = client;
        this.data = data;
    }

    static {
        EVENT_MAP.put(RemmeEvents.ATOMIC_SWAP, SwapInfoDTO.class);
        EVENT_MAP.put(RemmeEvents.BATCH, BatchInfoDTO.class);
        EVENT_MAP.put(RemmeEvents.BLOCKS, BlockInfoDTO.class);
        EVENT_MAP.put(RemmeEvents.TRANSFER, TransferInfoDTO.class);
    }
}

