/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.widgets;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/**
 * `FbN{bNXt̃XgR|Wbg
 */
public class CheckBoxListComposit extends Composite {
	/** setValue(String)Őݒ肷vpeBl̃f~^ */
	public static final String LIST_DELIMITOR = ";";
	private static final String INVALID_MARK = "@INVALID@";

	private Label titleLabel = null;
	private Table checkBoxTable = null;

	/**
	 * RXgN^B
	 * @param parent ẽR|Wbg
	 * @param title ^Cg
	 */
	public CheckBoxListComposit(Composite parent, String title) {
		super(parent, SWT.NONE);
		createContents(title);
	}

	/**
	 * R|Wbg̏sB
	 * @param title ^Cg
	 */
	protected void createContents(String title) {
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		setLayout(gl);

		titleLabel = new Label(this, SWT.NONE);
		titleLabel.setText(title);
		new Label(this, SWT.NONE);

		checkBoxTable = new Table(this, SWT.SINGLE | SWT.FULL_SELECTION
				| SWT.BORDER | SWT.CHECK);

		checkBoxTable.setLinesVisible(true);
		checkBoxTable.setItemCount(1);

		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.verticalSpan = 4;
		checkBoxTable.setLayoutData(gd);
	}

	/**
	 * e[uɒlǉB
	 * @param value ǉl
	 * @param valid Lɂꍇtrue
	 */
	public void addValue(String value, boolean valid) {
		if (value == null || value.length() == 0) {
			return;
		}
		TableItem newItem = new TableItem(getCheckBoxTable(), SWT.NONE);
		newItem.setChecked(valid);
		newItem.setText(0, value);
		columnPack();
	}

	/**
	 * e[u̒lύXB
	 * @param index ύX郌R[h̃CfbNX
	 * @param value ύXl
	 */
	public void changeValue(int index, String value) {
		if (value == null || value.length() == 0) {
			getCheckBoxTable().remove(index);
			return;
		}
		TableItem item = getCheckBoxTable().getItem(index);
		if (item != null) {
			String oldText = item.getText();
			if (!value.equals(oldText)) {
				item.setChecked(true);
				item.setText(value);
				columnPack();
			}
		}
	}

	/**
	 * e[u̒lĐݒ肷B
	 * @param value vpeB̒l
	 */
	public void setValue(String value) {
		if (value == null) {
			return;
		}
		setValue(value.split(LIST_DELIMITOR));
	}

	/**
	 * e[u̒lĐݒ肷B
	 * @param values l̔z
	 */
	protected void setValue(String[] values) {
		checkBoxTable.removeAll();
		if (values == null) {
			return;
		}

		for (String value : values) {
			if (value == null || value.length() == 0) {
				continue;
			}
			boolean invalidFlag = false;
			if (value.startsWith(INVALID_MARK)) {
				invalidFlag = true;
				value = value.substring(INVALID_MARK.length());
			}
			TableItem item = new TableItem(checkBoxTable, SWT.NONE);
			item.setChecked(!invalidFlag);
			item.setText(0, value);
		}
		columnPack();
	}

	/**
	 * ̕𐮂B
	 */
	private void columnPack() {
		TableColumn[] columns = getCheckBoxTable().getColumns();
		for (TableColumn column : columns) {
			column.pack();
		}
	}

	/**
	 * `FbN{bNXt̃e[u̒lԋpB
	 * @return e[u̒l(vpeB̌`)
	 */
	public String getTableValue() {
		StringBuilder sb = new StringBuilder();
		TableItem[] items = checkBoxTable.getItems();
		for (TableItem item : items) {
			if (!item.getChecked()) {
				sb.append(INVALID_MARK);
			}
			sb.append(item.getText(0));
			sb.append(LIST_DELIMITOR);
		}
		return sb.toString();
	}

	/**
	 * vpeB̒lp[XėLȒl݂̂ԋpB
	 * @param value vpeB̒l
	 * @return LȒl̔z
	 */
	public static String[] getValidValue(String value) {
		if (value == null) {
			return new String[0];
		}

		ArrayList<String> result = new ArrayList<String>();
		String[] values = value.split(LIST_DELIMITOR);
		for (String buf : values) {
			if (!buf.startsWith(INVALID_MARK)) {
				result.add(buf);
			}
		}
		return result.toArray(new String[0]);
	}

	/**
	 * `FbN{bNXt̃e[uԋpB
	 * @return `FbN{bNXt̃e[u
	 */
	protected Table getCheckBoxTable() {
		return checkBoxTable;
	}

}