/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package sample;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.highwide.resourcechecker.checker.ResourceCheckerLogic;
import jp.highwide.resourcechecker.checker.StringWithLineNumber;

/**
 * t@CɕsȕLqĂȂ`FbNTv
 */
public class IgnoreWordCheck extends ResourceCheckerLogic {
	/*
	 *  (non-Javadoc)
	 * @see jp.highwide.resourcechecker.checker.ResourceCheckerLogic#getName()
	 */
	@Override
	public String getName() {
		return "֑";
	}

	/*
	 *  (non-Javadoc)
	 * @see jp.highwide.resourcechecker.checker.ResourceCheckerLogic#doCheck(java.io.File, java.lang.String, java.util.List)
	 */
	@Override
	public void doCheck(File file,
			String fileExtension,
			List<StringWithLineNumber> source) throws Exception {
		final String rightWord = "C^tF[X";
		final String wrongWord = "C^[tF[X";
		final Pattern pattern = Pattern.compile(wrongWord);

		for (StringWithLineNumber line : source) {
			Matcher matcher = pattern.matcher(line.toString());
			if (matcher.find()) {
				MatchResult result = matcher.toMatchResult();
				int start = result.start();
				int end = result.end();

				HashMap<String, String> userData = new HashMap<String, String>();
				userData.put("RightWord", rightWord);

				addError("\"" + wrongWord + "\"͎gpȂƁB=\"" + rightWord
						+ "\"",
						line.getLineNumber(),
						line.getOffset() + start,
						line.getOffset() + end,
						userData);
			}
		}

	}

}
