<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class DesignsController extends AppController {

	var $name = 'Designs';
	var $uses = array('Design');
	var $components = array('RoleCheck');

	function index() {
		if(!$this->RoleCheck->checkDesign('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->Design->recursive = 0;
		$this->set('designs', $this->paginate());
	}

	function view() {
		if(!$this->RoleCheck->checkDesign('view')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if($this->Design->hasAny(array('user_id' => $this->Auth->user('id')))){
			$design = $this->Design->find('first',array('conditions'=> array('user_id'=> $this->Auth->user('id'))));
			$this->set('design', $design);
		}else{
			$this->redirect(array('action' => 'add'));
		}
	}

	function add() {
		if(!$this->RoleCheck->checkDesign('add')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!empty($this->data)) {
			$this->Design->create();
			if ($this->Design->save($this->data)) {
				$this->Session->setFlash(__('The design has been saved', true));
				$this->redirect(array('action' => 'view'));
			} else {
				$this->Session->setFlash(__('The design could not be saved. Please, try again.', true));
			}
		}
		$users = $this->Design->User->find('list');
		$this->set(compact('users'));
		$this->set('userid',$this->Auth->user('id'));
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkDesign('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid design', true));
			$this->redirect(array('action' => 'view'));
		}
		if (!empty($this->data)) {
			if ($this->Design->save($this->data)) {
				$this->Session->setFlash(__('The design has been saved', true));
				$this->redirect(array('action' => 'view'));
			} else {
				$this->Session->setFlash(__('The design could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Design->read(null, $id);
			if($this->data['Design']['user_id'] != $this->Auth->user('id')) {
				$this->Session->setFlash(__('Invalid Access', true));
				$this->redirect(array('controller'=> 'posts','action' => 'index'));
    		}
		}
		$users = $this->Design->User->find('list');
		$this->set(compact('users'));
	}

	function delete($id = null) {
		if(!$this->RoleCheck->checkDesign('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for design', true));
			$this->redirect(array('action'=>'view'));
		}else{
			$this->data = $this->Design->read(null, $id);
			if($this->data['Design']['user_id'] != $this->Auth->user('id')) {
				$this->Session->setFlash(__('Invalid Access', true));
				$this->redirect(array('controller'=> 'posts','action' => 'index'));
    		}
		}
		if ($this->Design->delete($id)) {
			$this->Session->setFlash(__('Design deleted', true));
			$this->redirect(array('action'=>'view'));
		}
		$this->Session->setFlash(__('Design was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>