<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class PostsController extends AppController {

	var $name = 'Posts';
	var $uses = array('Design');
	var $components = array('UserId','RoleCheck');
	var $helpers = array('Time','Geturl');

	function index() {
		if(!$this->RoleCheck->checkPost('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->Post->recursive = 0;
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		
		if($this->Auth->user('role') == 4 and 5){
			$this->set('posts', $this->paginate('Post', array('Post.user_id LIKE' => $this->UserId->getTeacherId(),'Post.draft Not LIKE' => 1)));
		}else{
			$this->set('posts', $this->paginate('Post', array('Post.user_id LIKE' => $this->UserId->getTeacherId())));
		}
		$this->set('loginId', $this->Auth->user('id'));
		
		if($this->Design->hasAny(array('user_id' => $this->UserId->getTeacherId()))){
			$topnews = $this->Design->find('first',array('fields'=> 'topnews','conditions'=> array('user_id'=> $this->UserId->getTeacherId())));
			$this->set('topnews', $topnews['Design']['topnews']);
		}else{
				$this->set('topnews', "This is the information area.");
		}
	}

	function add() {
		if(!$this->RoleCheck->checkPost('add')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!empty($this->data)) {
			$this->Post->create();
			if ($this->Post->save($this->data)) {
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The post could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->set('userid', $this->Auth->user('id'));
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkPost('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid post', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Post->save($this->data)) {
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The post could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'index'));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Post->read(null, $id);
		}
		$this->set('userid', $this->Auth->user('id'));
	}

	function delete($id = null) {
		if(!$this->RoleCheck->checkPost('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for post', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Post->delete($id)) {
			$this->Session->setFlash(__('Post deleted', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('Post was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>