<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class QuestionsController extends AppController {

	var $name = 'Questions';
	var $uses = array('Question','Post','Answer');
	var $components = array('UserId','RoleCheck');
	var $helpers = array('Time','Summary','Geturl','Js' => array('Jquery'));

	function index($id = null) {
		if(!$this->RoleCheck->checkQuestion('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid Post.', true));
			$this->redirect(array('action'=>'index'));
		}

        //Question view setteings.
		$posttitle = $this->Post->read('title', $id);
		$this->set('posttitle', $posttitle['Post']['title']);
		$this->set('postid', $id);
		$this->set('userid', $this->Auth->user('id'));
		$this->set('parentid', $this->Auth->user('parent_id'));		
		//Need or not need, for the response data.
		if($this->Auth->user('role') == 4){
			$this->Question->recursive = 2;
			$this->Question->hasMany['Answer']['conditions']  = array('Answer.user_id ' => $this->Auth->user('id'));
		}else{
			$this->Question->recursive = 0;
		}
		$this->params['sort'] = 'modified';
		$this->set('questions', $this->paginate('Question', array('Question.user_id LIKE' => $this->UserId->getTeacherId(), array('Question.post_id =' => $id))));

	}

	function view($id = null) {
		if(!$this->RoleCheck->checkQuestion('view')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid question', true));
			$this->redirect(array('action' => 'index'));
		}
		$question = $this->Question->read(null, $id);
		$this->set('questionTitle', $question['Question']['title']);
		$this->set('questionComment', $question['Question']['comment']);
		$this->set('max', $this->Auth->user('number'));
		$this->Answer->recursive = 1;
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$this->set('answers', $this->paginate('Answer', array(array('Answer.question_id LIKE' => $id) ,array('Answer.parentid LIKE' => $this->Auth->user('id')))));
		$this->set('userid', $this->Auth->user('id'));
	}

	function add() {
		if(!$this->RoleCheck->checkQuestion('add')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!empty($this->data)) {
			$this->Question->create();
			if ($this->Question->save($this->data)) {
				$this->Session->setFlash(__('The question has been saved', true));
				$this->redirect(array('action' => 'index',$this->data['Question']['post_id']));
			} else {
				$this->Session->setFlash(__('The question could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'index',$this->data['Question']['post_id']));
			}
		}
		$this->set('postid', $id);
		$this->set('userid', $this->Auth->user('id'));
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkQuestion('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid question', true));
			$this->redirect(array('controller' => 'posts','action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Question->save($this->data)) {
				$this->Session->setFlash(__('The question has been saved', true));
				$postid = $this->Question->read('post_id', $id);
				$this->redirect(array('action' => 'index',$postid['Question']['post_id']));
			} else {
				$this->Session->setFlash(__('The question could not be saved. Please, try again.', true));
				$postid = $this->Question->read('post_id', $id);
				$this->redirect(array('action' => 'index',$postid['Question']['post_id']));
			}
		}
		if (empty($this->data)) {
			$this->Question->recursive = -1;
			$this->data = $this->Question->read(null, $id);
		}
	}

	function delete($id = null) {
		if(!$this->RoleCheck->checkQuestion('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for question', true));
			$this->redirect(array('action'=>'index'));
		}
		$postid = $this->Question->read('post_id', $id);
		if ($this->Question->delete($id)) {
			$this->Session->setFlash(__('Question deleted', true));
			$this->redirect(array('action' => 'index',$postid['Question']['post_id']));
		}
		$this->Session->setFlash(__('Question was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>