<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 


class SummaryHelper extends AppHelper {

	function barurl($questions,$number) {
		$c1 = 0;
		$c2 = 0;
		$c3 = 0;
		$c4 = 0;
		if (empty($questions)) {
			return false;
		}
		foreach ($questions as $answer){
			switch ($answer['Answer']['select']) {
				case 1:
					$c1++;
					break;
				case 2:
					$c2++;
					break;
				case 3:
					$c3++;
					break;
				case 4:
					$c4++;
					break;
			}
		}
		$script = "
			$(document).ready(function(){
			      $.jqplot.config.enablePlugins = true;

				    understand = [$c1, $c2, $c3, $c4];
    				ticks = ['1', '2', '3', '4'];

    			    plot2 = $.jqplot('chart2',[understand],{
       					title: '',
       					legend: {
           					show: true
       					},
       					seriesDefaults: {
           					renderer: $.jqplot.BarRenderer,
           					pointLabels: {
          					     location: 'n'
           					}
       					},
       					series: [
          					{label: ' '},
       					],
       					axes: {
          				 	xaxis: {
          					     label: 'The selected number',
           						 renderer: $.jqplot.CategoryAxisRenderer,
           						 ticks: ticks
           					},
           					yaxis: {
               					max: $number,
               					min: 0,
               					tickOptions: {
                 				  formatString: '%d'
            	  				}
          					 }
       					}
   					 });
			});
			";
		return $this->output($script);
	}
}
?>