<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Atom03");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Atom03Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Atom03();
		$src = Http::body(Rhaco::url("feed.php?mode=atom03"));

		$feed->set($src);

		$this->_assert($feed,0);
	}
	function testGet(){
		$feed = new Atom03();
		$src = Http::body(Rhaco::url("feed.php?mode=atom03"));

		$feed->set($src);
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/atom03Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/atom03Result.xml")),$feed->get());
		
		$newfeed = new Atom03();
		$newfeed->set($feed->get());
		$this->_assert($newfeed,9);
	}
	function _assert($feed,$tzd){
		$this->assertEquals("0.3",$feed->getVersion());
		$this->assertEquals("venten",$feed->getTitle());
		$this->assertEquals("2006-07-20T20:29:59+09:00",$feed->getModified());	

		$link = $feed->getLink();
		$this->assertTrue(Variable::isClassType(AtomLink,$link));
		$this->assertEquals("alternate",$link->getRel());
		$this->assertEquals("text/html",$link->getType());
		$this->assertEquals("http://www.venten.net/",$link->getHref());

		$author = $feed->getAuthor();
		$this->assertTrue(Variable::isClassType(AtomAuthor,$author));
		$this->assertEquals("kenzii",$author->getName());


		$this->assertEquals(1,sizeof($feed->getEntry()));				

		foreach($feed->getEntry() as $entry){
			$this->assertTrue(Variable::isClassType(AtomEntry03,$entry));

			$this->assertEquals("引き続きTurboGearsの準備",$entry->getTitle());

			$linkList = $entry->getLink();
			
			$this->assertTrue(is_array($linkList));
			foreach($linkList as $link){
				$this->assertTrue(Variable::isClassType(AtomLink,$link));
				$this->assertEquals("alternate",$link->getRel());
				$this->assertEquals("text/html",$link->getType());
				$this->assertEquals("http://www.venten.net/?eid=495465",$link->getHref());
			}
			$this->assertEquals("http://www.venten.net/?eid=495465",$entry->getId());			
			
			$this->assertEquals("2006-08-11T12:27:19+09:00",$entry->getIssued());
			
			$this->assertEquals($this->_getAtomDate("2006-08-11T03:32:48Z",$tzd),$entry->getModified());
			$this->assertEquals($this->_getAtomDate("2006-08-11T03:27:19Z",$tzd),$entry->getCreated());
			
			$this->assertTrue($entry->getSummary() != "");			
			$this->assertTrue($entry->getContent() != "");
			
			$author = $entry->getAuthor();
			$this->assertTrue(Variable::isClassType(AtomAuthor,$author));
			$this->assertEquals("kenzii",$author->getName());
		}
	}
	function _getAtomDate($dateString,$tzd){
		return DateUtil::formatAtom(DateUtil::addHour(DateUtil::parseString($dateString),$tzd));		
	}
}
?>