<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.NetscapeBookmark");
Rhaco::import("tag.feed.data.NetscapeBookmarkItem");
Rhaco::import("io.FileUtil");

class NetscapeBookmarkTest extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new  NetscapeBookmark();
		$src = File::read(Rhaco::resource("bookmark.htm"));

		$feed->set($src);
		$this->_assert($feed);
	}
	function testGet(){
		$feed = new  NetscapeBookmark();
		$src = File::read(Rhaco::resource("bookmark.htm"));
		$feed->set($src);
		
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/NetscapeBookmarkResult.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/NetscapeBookmarkResult.xml")),$feed->get());
	}
	function _assert($feed){
		$this->assertEquals("Bookmarks",$feed->getTitle());		
		$this->assertEquals("Bookmarks",$feed->getHeader());		
		
		$block = $feed->getBlock();		
		$this->assertEquals(1,sizeof($block->getItem()));
		foreach($block->getItem() as $item){
			$this->assertTrue(Variable::isClassType(NetscapeBookmarkItem,$item));
			$this->assertTrue(strlen($item->getTitle()) > 0);
			$this->assertTrue(strlen($item->getLink()) > 0);
		}
	}
	function testItems(){
		$feed = new  NetscapeBookmark();
		$src = File::read(Rhaco::resource("bookmark.htm"));
		$feed->set($src);
		
		$items = $feed->getItems();
		$this->assertEquals(7,sizeof($items));
	}
}
?>