/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.kickmogu;

import java.text.*;
import java.util.*;
import java.util.zip.*;
import java.io.*;
import java.security.*;
import java.sql.Timestamp;
import org.apache.commons.betwixt.io.BeanWriter;

public class Util
{
    static public void zipFile(File zipfile, File[] targets) throws IOException {
    	ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(zipfile));
    	try {
    		for (int i = 0; i < targets.length; i++) {
    			ZipEntry ze = new ZipEntry(targets[i].getName());
    			zipout.putNextEntry(ze);
                BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(targets[i]));

                byte[] byteBuf=new byte[8192];
                for (;;) {
                        int iReadLen= inStream.read(byteBuf);
                        if(iReadLen==(-1)){
                                break;
                        }
                        zipout.write(byteBuf,0,iReadLen);
                }
                inStream.close();    			
    		}
    	} finally {
    		zipout.close();
    	}
    }

    static public void unzipFile(File baseFile, File zipfile) throws IOException {
    	ZipInputStream zipin = new ZipInputStream(new FileInputStream(zipfile));
    	ZipEntry zentry = null;
    	try {
    		while ((zentry = zipin.getNextEntry()) != null) {
    			if (zentry.isDirectory()) {
    				File dir = new File(baseFile, zentry.getName());
    				if (!dir.exists())
    					dir.mkdirs();
    			} else {
    				File extractFile = new File(baseFile, zentry.getName());
    				if (!extractFile.getParentFile().exists())
    					extractFile.getParentFile().mkdirs();
                    BufferedOutputStream outStream=new BufferedOutputStream(new FileOutputStream(extractFile));

                    byte[] byteBuf=new byte[8192];
                    for(;;){
                            int iReadLen= zipin.read(byteBuf);
                            if(iReadLen==(-1)){
                                    break;
                            }
                            outStream.write(byteBuf,0,iReadLen);
                    }
                    outStream.close();    			
    			}
    		}
    	} finally {
    		zipin.close();
    	}
    }
    
	public static String dumpBean(Object bean) {
		CharArrayWriter charout = new CharArrayWriter();
        BeanWriter out = new BeanWriter(charout);
        out.enablePrettyPrint();
        try {
        	out.write(bean);
        	out.close();
        } catch (Exception ex) {
        	return bean.toString();
        }
        return charout.toString();
	}
	
	static public String left(String src, int len) {
		if (src.length() <= len)
			return src;
		return src.substring(0, len);
	}
	
	static public String right(String src, int len) {
		if (src.length() <= len)
			return src;
		return src.substring(src.length() - len, src.length());
	}
	
	final static String PASSWD_CHAR = "0123456789abcdefghijklmnopqrstuvwxvzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	static public String createPassword(int pswdLen) {
		StringBuffer passwd = new StringBuffer();
		Random rnd = new Random();
		for (int i = 0; i < pswdLen; i++)
			passwd.append(PASSWD_CHAR.charAt(rnd.nextInt(PASSWD_CHAR.length())));
		return passwd.toString();
	}

	static public String createPassword() {
		return createPassword(10);
	}
	
	static public String correctUnicodeMapping(String src) {
		return src.replace('|', '\u2015').replace('\uff5e', '\u301c');
	}
	
	public static String makePassword(String eh_id, String pm_id) {
		MessageDigest md = null;
		try {
			md = MessageDigest.getInstance("SHA");
		} catch (Exception ex)  {
		}
		Random rand = new Random();
		md.update((eh_id + "\t"+ pm_id + "\t"+ System.currentTimeMillis()
			+ "\t" + rand.nextLong()
			+ "\t" + Runtime.getRuntime().freeMemory()).getBytes());
		byte[] dig = md.digest();
		StringBuffer passwd = new StringBuffer();
		for (int i = 0; i < dig.length; i++)
			passwd.append(Integer.toHexString(dig[i] < 0 ? dig[i] + 256 : dig[i]));
		return passwd.toString();
	}

	static public byte[] stream2byte(InputStream bin) throws IOException {
		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		byte[] buf = new byte[4096];
		int len;
		while ((len = bin.read(buf)) != -1)
			byteOut.write(buf, 0, len);
		byteOut.close();
		return byteOut.toByteArray();		
	}

	static public byte[] gzip2byte(byte[] gzipBody) throws IOException {
		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		byte[] buf = new byte[4096];
		int len;
		ByteArrayInputStream byteIn = new ByteArrayInputStream(gzipBody);
		GZIPInputStream gzipIn = new GZIPInputStream(byteIn);
		byteOut = new ByteArrayOutputStream();
		while ((len = gzipIn.read(buf)) != -1)
			byteOut.write(buf, 0, len);
		byteOut.close();
		return byteOut.toByteArray();		
	}

	static public byte[] byte2gzip(byte[] src) throws IOException {
		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		GZIPOutputStream gzipOut = new GZIPOutputStream(byteOut);
		gzipOut.write(src, 0, src.length);
		gzipOut.flush();
		gzipOut.close();
		byteOut.close();
		byte[] gzipBody = byteOut.toByteArray();		
		return gzipBody;
	}

	static public String reader2String(Reader in) throws IOException {
		BufferedReader bin = new BufferedReader(in);
		String ln = "";
		StringBuffer out = new StringBuffer();
		while ((ln = bin.readLine()) != null)
			out.append(ln);	
		return out.toString();
	}

	static public String getStackTrace(Exception ex) {
		StringWriter sout = new StringWriter();
		PrintWriter out = new PrintWriter(sout);
		ex.printStackTrace(out);
		return sout.toString();
	}
	
	static public boolean isDate(String fmt, String date) {
		SimpleDateFormat sfmt = new SimpleDateFormat(fmt);
		sfmt.setLenient(false);
		ParsePosition pp = new ParsePosition(0);
		java.util.Date dt = sfmt.parse(date, pp);
		return dt != null && pp.getIndex() == date.length() ? true : false;
	}

	static public String toStr(Object val) {
		return toStr((String) val);
	}

	static public String toStr(String val) {
		return val == null || val.equals("") ? "" : val;
	}

	final static String[][] UNPRINT_HTML_CHAR = {
			{"&", "&amp;"},
			{"<", "&lt;"},
			{">", "&gt;"},
			{"\"", "&quot;"},
			};
	static public String convHtmlChar(String src) {
		for (int i = 0; i < UNPRINT_HTML_CHAR.length; i++) {
			int pos = 0;
			while ((pos = src.indexOf(UNPRINT_HTML_CHAR[i][0].charAt(0), pos)) != -1) {
				src = src.substring(0, pos) + UNPRINT_HTML_CHAR[i][1] + src.substring(pos + 1);
				pos += UNPRINT_HTML_CHAR[i][1].length() - 1;
			}
		}
		return src;
	}

	final static String[][] CONV_HTML_CHAR = {
			{"&#38;", "&"},
			{"&#60;", "<"},
			{"&#62;", ">"},
			{"&#34;", "\""},
			{"&#47;", "/"},
			};

	static public String convCharRef2Str(String src) {

		for (int i = 0; i < CONV_HTML_CHAR.length; i++) {
			src = src.replace(CONV_HTML_CHAR[i][0], CONV_HTML_CHAR[i][1]);
		}
		return src;
	}

	static public String decodeHex(String src) {
		StringBuffer dest = new StringBuffer();
		for (int i = 0; i < src.length() / 4; i++) {
			String hex = src.substring(i * 4, i * 4 + 4);
			dest.append((char) Integer.parseInt(hex, 16));
		}
		return dest.toString();
	}

	static public String encodeHex(String src) {
		StringBuffer dest = new StringBuffer();
		for (int i = 0; i < src.length(); i++) {
			String hex = "000" + Integer.toHexString((int) src.charAt(i));
			dest.append(hex.substring(hex.length() - 4));
		}
		return dest.toString();
	}

    static BitSet dontNeedEncoding;
    static final int caseDiff = ('a' - 'A');

    /* The list of characters that are not encoded have been determined by
       referencing O'Reilly's "HTML: The Definitive Guide" (page 164). */

    static {
		dontNeedEncoding = new BitSet(256);
		int i;
		for (i = 'a'; i <= 'z'; i++) {
			dontNeedEncoding.set(i);
		}
		for (i = 'A'; i <= 'Z'; i++) {
			dontNeedEncoding.set(i);
		}
		for (i = '0'; i <= '9'; i++) {
			dontNeedEncoding.set(i);
		}
		dontNeedEncoding.set(' '); /* encoding a space to a + is done in the encode() method */
		dontNeedEncoding.set('-');
		dontNeedEncoding.set('_');
		dontNeedEncoding.set('.');
		dontNeedEncoding.set('*');
    }

    /**
     * Translates a string into <code>x-www-form-urlencoded</code> format.
     *
     * @param   s   <code>String</code> to be translated.
     * @return  the translated <code>String</code>.
     */
    public static String urlencode(String s, String enc) throws UnsupportedEncodingException {
		int maxBytesPerChar = 10;
			StringBuffer out = new StringBuffer(s.length());
		ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
		OutputStreamWriter writer = new OutputStreamWriter(buf, enc);

		for (int i = 0; i < s.length(); i++) {
			int c = (int)s.charAt(i);
			if (dontNeedEncoding.get(c)) {
			if (c == ' ') {
				c = '+';
			}
			out.append((char)c);
			} else {
			// convert to external encoding before hex conversion
			try {
				writer.write(c);
				writer.flush();
			} catch(IOException e) {
				buf.reset();
				continue;
			}
			byte[] ba = buf.toByteArray();
			for (int j = 0; j < ba.length; j++) {
				out.append('%');
				char ch = Character.forDigit((ba[j] >> 4) & 0xF, 16);
				// converting to use uppercase letter as part of
				// the hex value if ch is a letter.
				if (Character.isLetter(ch)) {
					ch -= caseDiff;
				}
				out.append(ch);
				ch = Character.forDigit(ba[j] & 0xF, 16);
				if (Character.isLetter(ch)) {
					ch -= caseDiff;
				}
				out.append(ch);
			}
			buf.reset();
			}
		}
		return out.toString();
    }

    public static Timestamp yyyymmdd2Timestamp(String ymd) {
		ymd = ymd.replace('/', '-');
		return java.sql.Timestamp.valueOf(ymd + " 00:00:00.0");
	}
}
