/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2005/06/23
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package com.kickmogu.rhythm.board.dao;

import com.kickmogu.rhythm.board.*;

/**
 * @author mogu
 */
public interface BoardDao {
    public Class BEAN = Board.class;
    
    public static final String BasicSql = "select Board.*, Member.name as registrantName from Board, Member where ";
    public static final String JoinSql = " and Board.registrant = Member.id";
    
    public static final String listRootBoards_SQL = BasicSql + " depth = 0 and boardTreeId = ? " + JoinSql + " order by rootId desc, seq";
    public static final String listBoardThreads_SQL = BasicSql + " rootId = ? " + JoinSql + " order by seq";
    public static final String getBoard_SQL = BasicSql + "Board.id = ?" + JoinSql;
    
    public int update(Board board);
    
    public int insert(Board board);

    public int delete(Board board);
    
    public Board getBoard(int id);

    public Board[] listRootBoards(int categoryId);
    
    public Board[] listBoardThreads(int rootId);
}
