/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * 쐬: 2007/01/15
 *
 */
package com.kickmogu.rhythm.core;

import java.lang.reflect.Constructor;
import com.kickmogu.StopWatch;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.io.*;
import org.apache.log4j.Category;

public class HttpCmdDispatcher extends HttpServlet {

	static Category log = Category.getInstance(HttpCmdDispatcher.class.getName());

	private BaseResult doService(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		BaseResult result = new BaseResult();
		if (!SessionManager.isValidSession(req.getParameter("sessionId"), Integer.parseInt(req.getParameter("memberId")))) {
			result.setStatusCode(10);
			return result;
		}
		Class actionClass = Class.forName(req.getParameter("className"));
		Constructor actionConst = actionClass.getConstructor(new Class[] {});
		Map<String, String[]> params = req.getParameterMap();
		HttpCmdAction action = (HttpCmdAction) actionConst.newInstance(new Object[] {});
		StopWatch stpWtch = new StopWatch();
		result = action.doAction(params);
		log.info(req.getParameter("className") + " call time:" + stpWtch.getPastTime());
		if (result.getStatusCode() != 0) {
			return result;
		}
		PrintWriter out = new PrintWriter(new OutputStreamWriter(resp.getOutputStream(), "UTF8"));
		out.println("0");
		out.print(result.getResult().toString());
		out.close();
		return result;
	}
	
	protected void service(HttpServletRequest req, HttpServletResponse resp) {
		try {
			resp.setHeader("Cache-Control", "max-age=0, must-revalidate");
			req.setCharacterEncoding("UTF8");
			BaseResult result = doService(req, resp);
			if (result.getStatusCode() != 0) {
				PrintWriter out = new PrintWriter(new OutputStreamWriter(resp.getOutputStream(), "UTF8"));
				out.print(result.getStatusCode() + "\t" + result.getStatusMessage());
				out.close();
			}
		} catch (Exception ex) {
			log.error(ex);
			resp.setStatus(503);
			try {
				ex.printStackTrace(new PrintWriter(resp.getWriter()));
			} catch (IOException iex) {
				log.error(iex);
			}
		}
	}

}
