/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/11/28
 *
 */
package com.kickmogu.rhythm.core;

import java.util.*;

import com.kickmogu.Config;
import com.kickmogu.rhythm.core.dao.*;
import com.kickmogu.s2.S2Util;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class Member {
	static Category log = Category.getInstance(Member.class.getName());

	public final static String UNIQ_KEYNAME = "rhtym member id";

	private int id;
	private String loginid;
	private String name;
	private String passwd;
	private String sessionId;
	private int payHour;
	// ʔ
	private int trafficExpenses;
	/* ʔ
	 * 0 EEE@
	 * 1 EEE@zŒ
 	 */
	private int trafficExpensesKind;
	private int restMinutes;
	
	public boolean isLogined(BaseResult result) {
		if (!SessionManager.isValidSession(getSessionId(), getId())) {
			result.setStatusCode(10);
			return false;
		}
		return true;
	}
	
	/**
	 * @return id ߂܂B
	 */
	public int getId() {
		return id;
	}
	/**
	 * @param id id ݒB
	 */
	public void setId(int id) {
		this.id = id;
	}
	/**
	 * @return logindid ߂܂B
	 */
	public String getLoginid() {
		return loginid;
	}
	/**
	 * @param logindid logindid ݒB
	 */
	public void setLoginid(String logindid) {
		this.loginid = logindid;
	}
	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name name ݒB
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return password ߂܂B
	 */
	public String getPasswd() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.member.password"))) {
			return Config.getProperty("demo.member.password");
		}
		return passwd;
	}
	/**
	 * @param password password ݒB
	 */
	public void setPasswd(String password) {
		this.passwd = password;
	}
	/**
	 * @return payHour ߂܂B
	 */
	public int getPayHour() {
		return payHour;
	}
	/**
	 * @param payHour payHour ݒB
	 */
	public void setPayHour(int payHour) {
		this.payHour = payHour;
	}
	/**
	 * @return restMinutes ߂܂B
	 */
	public int getRestMinutes() {
		return restMinutes;
	}
	/**
	 * @param restMinutes restMinutes ݒB
	 */
	public void setRestMinutes(int restMinutes) {
		this.restMinutes = restMinutes;
	}
	/**
	 * @return trafficExpenses ߂܂B
	 */
	public int getTrafficExpenses() {
		return trafficExpenses;
	}
	/**
	 * @param trafficExpenses trafficExpenses ݒB
	 */
	public void setTrafficExpenses(int trafficExpenses) {
		this.trafficExpenses = trafficExpenses;
	}
	
	/**
	 * w肳Č邩`FbN
	 * @param permCode@
	 * @return@True
	 * @throws Exception
	 */
	public boolean hasPermission(String permCode) throws Exception {
		return true;
	}
	
	/**
	 * Ă錠̒Ŏw肳PermissionCodePermissionTargetԂ
	 * @param permCode
	 * @return
	 * @throws Exception
	 */
	public List<PermissionTarget> getAssignTarget(String permCode) throws Exception {
		List<Role> roles = getBelongRoles();
		List<PermissionTarget> results = new ArrayList<PermissionTarget>();
		for (int i = 0; i < roles.size(); i++) {
			results.addAll(roles.get(i).getAssignTarget(permCode));
		}
		return results;
	}	
	/**
	 * ĂRoleIDԂ
	 * @return
	 */
	public List<Role> getBelongRoles() {
		RoleMemberDao roleMemberDao = (RoleMemberDao) S2Util.getS2Container().getComponent(RoleMemberDao.class);
		List<RoleMember> roleMembers = roleMemberDao.getByMemberId(getId());
		List results = new ArrayList();
		for (int i = 0; i < roleMembers.size(); i++) {
			RhythmTree role = (Role) RhythmTreeManager.getRoot(Role.class).search(roleMembers.get(i).getRoleId());
			// Role폜ĂȂΎ擾
			if (role != null) {
				results.addAll(role.getAll());
			}
		}
		return (List<Role>) results;
	}

	/**
	 * @return trafficExpensesKind ߂܂B
	 */
	public int getTrafficExpensesKind() {
		return trafficExpensesKind;
	}

	/**
	 * @param trafficExpensesKind trafficExpensesKind ݒB
	 */
	public void setTrafficExpensesKind(int trafficExpensesKind) {
		this.trafficExpensesKind = trafficExpensesKind;
	}

	/**
	 * @return sessionId ߂܂B
	 */
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * @param sessionId sessionId ݒB
	 */
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}
}
